/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-client-gen. DO NOT EDIT.

package fake

import (
	rest "k8s.io/client-go/rest"

	kcptesting "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/testing"
	"github.com/kcp-dev/logicalcluster/v3"

	kcpcachev1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/cache/v1alpha1"
	cachev1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/typed/cache/v1alpha1"
)

var _ kcpcachev1alpha1.CacheV1alpha1ClusterInterface = (*CacheV1alpha1ClusterClient)(nil)

type CacheV1alpha1ClusterClient struct {
	*kcptesting.Fake
}

func (c *CacheV1alpha1ClusterClient) Cluster(clusterPath logicalcluster.Path) cachev1alpha1.CacheV1alpha1Interface {
	if clusterPath == logicalcluster.Wildcard {
		panic("A specific cluster must be provided when scoping, not the wildcard.")
	}
	return &CacheV1alpha1Client{Fake: c.Fake, ClusterPath: clusterPath}
}

func (c *CacheV1alpha1ClusterClient) CachedObjects() kcpcachev1alpha1.CachedObjectClusterInterface {
	return newFakeCachedObjectClusterClient(c)
}

func (c *CacheV1alpha1ClusterClient) CachedResources() kcpcachev1alpha1.CachedResourceClusterInterface {
	return newFakeCachedResourceClusterClient(c)
}

func (c *CacheV1alpha1ClusterClient) CachedResourceEndpointSlices() kcpcachev1alpha1.CachedResourceEndpointSliceClusterInterface {
	return newFakeCachedResourceEndpointSliceClusterClient(c)
}

type CacheV1alpha1Client struct {
	*kcptesting.Fake
	ClusterPath logicalcluster.Path
}

func (c *CacheV1alpha1Client) CachedObjects() cachev1alpha1.CachedObjectInterface {
	return newFakeCachedObjectClient(c.Fake, c.ClusterPath)
}

func (c *CacheV1alpha1Client) CachedResources() cachev1alpha1.CachedResourceInterface {
	return newFakeCachedResourceClient(c.Fake, c.ClusterPath)
}

func (c *CacheV1alpha1Client) CachedResourceEndpointSlices() cachev1alpha1.CachedResourceEndpointSliceInterface {
	return newFakeCachedResourceEndpointSliceClient(c.Fake, c.ClusterPath)
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *CacheV1alpha1Client) RESTClient() rest.Interface {
	var ret *rest.RESTClient
	return ret
}
