/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-client-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	watch "k8s.io/apimachinery/pkg/watch"

	kcpclient "github.com/kcp-dev/apimachinery/v2/pkg/client"
	"github.com/kcp-dev/logicalcluster/v3"

	kcpcachev1alpha1 "github.com/kcp-dev/kcp/sdk/apis/cache/v1alpha1"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/typed/cache/v1alpha1"
)

// CachedObjectsClusterGetter has a method to return a CachedObjectClusterInterface.
// A group's cluster client should implement this interface.
type CachedObjectsClusterGetter interface {
	CachedObjects() CachedObjectClusterInterface
}

// CachedObjectClusterInterface can operate on CachedObjects across all clusters,
// or scope down to one cluster and return a kcpv1alpha1.CachedObjectInterface.
type CachedObjectClusterInterface interface {
	Cluster(logicalcluster.Path) kcpv1alpha1.CachedObjectInterface
	List(ctx context.Context, opts v1.ListOptions) (*kcpcachev1alpha1.CachedObjectList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	CachedObjectClusterExpansion
}

type cachedObjectsClusterInterface struct {
	clientCache kcpclient.Cache[*kcpv1alpha1.CacheV1alpha1Client]
}

// Cluster scopes the client down to a particular cluster.
func (c *cachedObjectsClusterInterface) Cluster(clusterPath logicalcluster.Path) kcpv1alpha1.CachedObjectInterface {
	if clusterPath == logicalcluster.Wildcard {
		panic("A specific cluster must be provided when scoping, not the wildcard.")
	}

	return c.clientCache.ClusterOrDie(clusterPath).CachedObjects()
}

// List returns the entire collection of all CachedObjects across all clusters.
func (c *cachedObjectsClusterInterface) List(ctx context.Context, opts v1.ListOptions) (*kcpcachev1alpha1.CachedObjectList, error) {
	return c.clientCache.ClusterOrDie(logicalcluster.Wildcard).CachedObjects().List(ctx, opts)
}

// Watch begins to watch all CachedObjects across all clusters.
func (c *cachedObjectsClusterInterface) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.clientCache.ClusterOrDie(logicalcluster.Wildcard).CachedObjects().Watch(ctx, opts)
}
