/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-client-gen. DO NOT EDIT.

package fake

import (
	kcpgentype "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/gentype"
	kcptesting "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/testing"
	"github.com/kcp-dev/logicalcluster/v3"

	apisv1alpha2 "github.com/kcp-dev/kcp/sdk/apis/apis/v1alpha2"
	kcpv1alpha2 "github.com/kcp-dev/kcp/sdk/client/applyconfiguration/apis/v1alpha2"
	typedkcpapisv1alpha2 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/apis/v1alpha2"
	typedapisv1alpha2 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/typed/apis/v1alpha2"
)

// aPIExportClusterClient implements APIExportClusterInterface
type aPIExportClusterClient struct {
	*kcpgentype.FakeClusterClientWithList[*apisv1alpha2.APIExport, *apisv1alpha2.APIExportList]
	Fake *kcptesting.Fake
}

func newFakeAPIExportClusterClient(fake *ApisV1alpha2ClusterClient) typedkcpapisv1alpha2.APIExportClusterInterface {
	return &aPIExportClusterClient{
		kcpgentype.NewFakeClusterClientWithList[*apisv1alpha2.APIExport, *apisv1alpha2.APIExportList](
			fake.Fake,
			apisv1alpha2.SchemeGroupVersion.WithResource("apiexports"),
			apisv1alpha2.SchemeGroupVersion.WithKind("APIExport"),
			func() *apisv1alpha2.APIExport { return &apisv1alpha2.APIExport{} },
			func() *apisv1alpha2.APIExportList { return &apisv1alpha2.APIExportList{} },
			func(dst, src *apisv1alpha2.APIExportList) { dst.ListMeta = src.ListMeta },
			func(list *apisv1alpha2.APIExportList) []*apisv1alpha2.APIExport {
				return kcpgentype.ToPointerSlice(list.Items)
			},
			func(list *apisv1alpha2.APIExportList, items []*apisv1alpha2.APIExport) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake.Fake,
	}
}

func (c *aPIExportClusterClient) Cluster(cluster logicalcluster.Path) typedapisv1alpha2.APIExportInterface {
	return newFakeAPIExportClient(c.Fake, cluster)
}

// aPIExportScopedClient implements APIExportInterface
type aPIExportScopedClient struct {
	*kcpgentype.FakeClientWithListAndApply[*apisv1alpha2.APIExport, *apisv1alpha2.APIExportList, *kcpv1alpha2.APIExportApplyConfiguration]
	Fake        *kcptesting.Fake
	ClusterPath logicalcluster.Path
}

func newFakeAPIExportClient(fake *kcptesting.Fake, clusterPath logicalcluster.Path) typedapisv1alpha2.APIExportInterface {
	return &aPIExportScopedClient{
		kcpgentype.NewFakeClientWithListAndApply[*apisv1alpha2.APIExport, *apisv1alpha2.APIExportList, *kcpv1alpha2.APIExportApplyConfiguration](
			fake,
			clusterPath,
			"",
			apisv1alpha2.SchemeGroupVersion.WithResource("apiexports"),
			apisv1alpha2.SchemeGroupVersion.WithKind("APIExport"),
			func() *apisv1alpha2.APIExport { return &apisv1alpha2.APIExport{} },
			func() *apisv1alpha2.APIExportList { return &apisv1alpha2.APIExportList{} },
			func(dst, src *apisv1alpha2.APIExportList) { dst.ListMeta = src.ListMeta },
			func(list *apisv1alpha2.APIExportList) []*apisv1alpha2.APIExport {
				return kcpgentype.ToPointerSlice(list.Items)
			},
			func(list *apisv1alpha2.APIExportList, items []*apisv1alpha2.APIExport) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake,
		clusterPath,
	}
}
