/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-client-gen. DO NOT EDIT.

package fake

import (
	kcpgentype "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/gentype"
	kcptesting "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/testing"
	"github.com/kcp-dev/logicalcluster/v3"

	apisv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/apis/v1alpha1"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/applyconfiguration/apis/v1alpha1"
	typedkcpapisv1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/apis/v1alpha1"
	typedapisv1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/typed/apis/v1alpha1"
)

// aPIResourceSchemaClusterClient implements APIResourceSchemaClusterInterface
type aPIResourceSchemaClusterClient struct {
	*kcpgentype.FakeClusterClientWithList[*apisv1alpha1.APIResourceSchema, *apisv1alpha1.APIResourceSchemaList]
	Fake *kcptesting.Fake
}

func newFakeAPIResourceSchemaClusterClient(fake *ApisV1alpha1ClusterClient) typedkcpapisv1alpha1.APIResourceSchemaClusterInterface {
	return &aPIResourceSchemaClusterClient{
		kcpgentype.NewFakeClusterClientWithList[*apisv1alpha1.APIResourceSchema, *apisv1alpha1.APIResourceSchemaList](
			fake.Fake,
			apisv1alpha1.SchemeGroupVersion.WithResource("apiresourceschemas"),
			apisv1alpha1.SchemeGroupVersion.WithKind("APIResourceSchema"),
			func() *apisv1alpha1.APIResourceSchema { return &apisv1alpha1.APIResourceSchema{} },
			func() *apisv1alpha1.APIResourceSchemaList { return &apisv1alpha1.APIResourceSchemaList{} },
			func(dst, src *apisv1alpha1.APIResourceSchemaList) { dst.ListMeta = src.ListMeta },
			func(list *apisv1alpha1.APIResourceSchemaList) []*apisv1alpha1.APIResourceSchema {
				return kcpgentype.ToPointerSlice(list.Items)
			},
			func(list *apisv1alpha1.APIResourceSchemaList, items []*apisv1alpha1.APIResourceSchema) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake.Fake,
	}
}

func (c *aPIResourceSchemaClusterClient) Cluster(cluster logicalcluster.Path) typedapisv1alpha1.APIResourceSchemaInterface {
	return newFakeAPIResourceSchemaClient(c.Fake, cluster)
}

// aPIResourceSchemaScopedClient implements APIResourceSchemaInterface
type aPIResourceSchemaScopedClient struct {
	*kcpgentype.FakeClientWithListAndApply[*apisv1alpha1.APIResourceSchema, *apisv1alpha1.APIResourceSchemaList, *kcpv1alpha1.APIResourceSchemaApplyConfiguration]
	Fake        *kcptesting.Fake
	ClusterPath logicalcluster.Path
}

func newFakeAPIResourceSchemaClient(fake *kcptesting.Fake, clusterPath logicalcluster.Path) typedapisv1alpha1.APIResourceSchemaInterface {
	return &aPIResourceSchemaScopedClient{
		kcpgentype.NewFakeClientWithListAndApply[*apisv1alpha1.APIResourceSchema, *apisv1alpha1.APIResourceSchemaList, *kcpv1alpha1.APIResourceSchemaApplyConfiguration](
			fake,
			clusterPath,
			"",
			apisv1alpha1.SchemeGroupVersion.WithResource("apiresourceschemas"),
			apisv1alpha1.SchemeGroupVersion.WithKind("APIResourceSchema"),
			func() *apisv1alpha1.APIResourceSchema { return &apisv1alpha1.APIResourceSchema{} },
			func() *apisv1alpha1.APIResourceSchemaList { return &apisv1alpha1.APIResourceSchemaList{} },
			func(dst, src *apisv1alpha1.APIResourceSchemaList) { dst.ListMeta = src.ListMeta },
			func(list *apisv1alpha1.APIResourceSchemaList) []*apisv1alpha1.APIResourceSchema {
				return kcpgentype.ToPointerSlice(list.Items)
			},
			func(list *apisv1alpha1.APIResourceSchemaList, items []*apisv1alpha1.APIResourceSchema) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake,
		clusterPath,
	}
}
