/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-client-gen. DO NOT EDIT.

package fake

import (
	kcpgentype "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/gentype"
	kcptesting "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/testing"
	"github.com/kcp-dev/logicalcluster/v3"

	apisv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/apis/v1alpha1"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/applyconfiguration/apis/v1alpha1"
	typedkcpapisv1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/apis/v1alpha1"
	typedapisv1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/typed/apis/v1alpha1"
)

// aPIExportClusterClient implements APIExportClusterInterface
type aPIExportClusterClient struct {
	*kcpgentype.FakeClusterClientWithList[*apisv1alpha1.APIExport, *apisv1alpha1.APIExportList]
	Fake *kcptesting.Fake
}

func newFakeAPIExportClusterClient(fake *ApisV1alpha1ClusterClient) typedkcpapisv1alpha1.APIExportClusterInterface {
	return &aPIExportClusterClient{
		kcpgentype.NewFakeClusterClientWithList[*apisv1alpha1.APIExport, *apisv1alpha1.APIExportList](
			fake.Fake,
			apisv1alpha1.SchemeGroupVersion.WithResource("apiexports"),
			apisv1alpha1.SchemeGroupVersion.WithKind("APIExport"),
			func() *apisv1alpha1.APIExport { return &apisv1alpha1.APIExport{} },
			func() *apisv1alpha1.APIExportList { return &apisv1alpha1.APIExportList{} },
			func(dst, src *apisv1alpha1.APIExportList) { dst.ListMeta = src.ListMeta },
			func(list *apisv1alpha1.APIExportList) []*apisv1alpha1.APIExport {
				return kcpgentype.ToPointerSlice(list.Items)
			},
			func(list *apisv1alpha1.APIExportList, items []*apisv1alpha1.APIExport) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake.Fake,
	}
}

func (c *aPIExportClusterClient) Cluster(cluster logicalcluster.Path) typedapisv1alpha1.APIExportInterface {
	return newFakeAPIExportClient(c.Fake, cluster)
}

// aPIExportScopedClient implements APIExportInterface
type aPIExportScopedClient struct {
	*kcpgentype.FakeClientWithListAndApply[*apisv1alpha1.APIExport, *apisv1alpha1.APIExportList, *kcpv1alpha1.APIExportApplyConfiguration]
	Fake        *kcptesting.Fake
	ClusterPath logicalcluster.Path
}

func newFakeAPIExportClient(fake *kcptesting.Fake, clusterPath logicalcluster.Path) typedapisv1alpha1.APIExportInterface {
	return &aPIExportScopedClient{
		kcpgentype.NewFakeClientWithListAndApply[*apisv1alpha1.APIExport, *apisv1alpha1.APIExportList, *kcpv1alpha1.APIExportApplyConfiguration](
			fake,
			clusterPath,
			"",
			apisv1alpha1.SchemeGroupVersion.WithResource("apiexports"),
			apisv1alpha1.SchemeGroupVersion.WithKind("APIExport"),
			func() *apisv1alpha1.APIExport { return &apisv1alpha1.APIExport{} },
			func() *apisv1alpha1.APIExportList { return &apisv1alpha1.APIExportList{} },
			func(dst, src *apisv1alpha1.APIExportList) { dst.ListMeta = src.ListMeta },
			func(list *apisv1alpha1.APIExportList) []*apisv1alpha1.APIExport {
				return kcpgentype.ToPointerSlice(list.Items)
			},
			func(list *apisv1alpha1.APIExportList, items []*apisv1alpha1.APIExport) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake,
		clusterPath,
	}
}
