/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-client-gen. DO NOT EDIT.

package fake

import (
	kcpgentype "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/gentype"
	kcptesting "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/testing"
	"github.com/kcp-dev/logicalcluster/v3"

	apisv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/apis/v1alpha1"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/applyconfiguration/apis/v1alpha1"
	typedkcpapisv1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/apis/v1alpha1"
	typedapisv1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/typed/apis/v1alpha1"
)

// aPIBindingClusterClient implements APIBindingClusterInterface
type aPIBindingClusterClient struct {
	*kcpgentype.FakeClusterClientWithList[*apisv1alpha1.APIBinding, *apisv1alpha1.APIBindingList]
	Fake *kcptesting.Fake
}

func newFakeAPIBindingClusterClient(fake *ApisV1alpha1ClusterClient) typedkcpapisv1alpha1.APIBindingClusterInterface {
	return &aPIBindingClusterClient{
		kcpgentype.NewFakeClusterClientWithList[*apisv1alpha1.APIBinding, *apisv1alpha1.APIBindingList](
			fake.Fake,
			apisv1alpha1.SchemeGroupVersion.WithResource("apibindings"),
			apisv1alpha1.SchemeGroupVersion.WithKind("APIBinding"),
			func() *apisv1alpha1.APIBinding { return &apisv1alpha1.APIBinding{} },
			func() *apisv1alpha1.APIBindingList { return &apisv1alpha1.APIBindingList{} },
			func(dst, src *apisv1alpha1.APIBindingList) { dst.ListMeta = src.ListMeta },
			func(list *apisv1alpha1.APIBindingList) []*apisv1alpha1.APIBinding {
				return kcpgentype.ToPointerSlice(list.Items)
			},
			func(list *apisv1alpha1.APIBindingList, items []*apisv1alpha1.APIBinding) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake.Fake,
	}
}

func (c *aPIBindingClusterClient) Cluster(cluster logicalcluster.Path) typedapisv1alpha1.APIBindingInterface {
	return newFakeAPIBindingClient(c.Fake, cluster)
}

// aPIBindingScopedClient implements APIBindingInterface
type aPIBindingScopedClient struct {
	*kcpgentype.FakeClientWithListAndApply[*apisv1alpha1.APIBinding, *apisv1alpha1.APIBindingList, *kcpv1alpha1.APIBindingApplyConfiguration]
	Fake        *kcptesting.Fake
	ClusterPath logicalcluster.Path
}

func newFakeAPIBindingClient(fake *kcptesting.Fake, clusterPath logicalcluster.Path) typedapisv1alpha1.APIBindingInterface {
	return &aPIBindingScopedClient{
		kcpgentype.NewFakeClientWithListAndApply[*apisv1alpha1.APIBinding, *apisv1alpha1.APIBindingList, *kcpv1alpha1.APIBindingApplyConfiguration](
			fake,
			clusterPath,
			"",
			apisv1alpha1.SchemeGroupVersion.WithResource("apibindings"),
			apisv1alpha1.SchemeGroupVersion.WithKind("APIBinding"),
			func() *apisv1alpha1.APIBinding { return &apisv1alpha1.APIBinding{} },
			func() *apisv1alpha1.APIBindingList { return &apisv1alpha1.APIBindingList{} },
			func(dst, src *apisv1alpha1.APIBindingList) { dst.ListMeta = src.ListMeta },
			func(list *apisv1alpha1.APIBindingList) []*apisv1alpha1.APIBinding {
				return kcpgentype.ToPointerSlice(list.Items)
			},
			func(list *apisv1alpha1.APIBindingList, items []*apisv1alpha1.APIBinding) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake,
		clusterPath,
	}
}
