/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-client-gen. DO NOT EDIT.

package fake

import (
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/client-go/discovery"

	kcpfakediscovery "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/discovery/fake"
	kcptesting "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/testing"
	"github.com/kcp-dev/logicalcluster/v3"

	kcpapplyconfiguration "github.com/kcp-dev/kcp/sdk/client/applyconfiguration"
	clientset "github.com/kcp-dev/kcp/sdk/client/clientset/versioned"
	kcpclientset "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster"
	kcpclientscheme "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/scheme"
	kcpapisv1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/apis/v1alpha1"
	kcpfakeapisv1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/apis/v1alpha1/fake"
	kcpapisv1alpha2 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/apis/v1alpha2"
	kcpfakeapisv1alpha2 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/apis/v1alpha2/fake"
	kcpcachev1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/cache/v1alpha1"
	kcpfakecachev1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/cache/v1alpha1/fake"
	kcpcorev1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/core/v1alpha1"
	kcpfakecorev1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/core/v1alpha1/fake"
	kcptenancyv1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/tenancy/v1alpha1"
	kcpfaketenancyv1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/tenancy/v1alpha1/fake"
	kcptopologyv1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/topology/v1alpha1"
	kcpfaketopologyv1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/topology/v1alpha1/fake"
	apisv1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/typed/apis/v1alpha1"
	apisv1alpha2 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/typed/apis/v1alpha2"
	cachev1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/typed/cache/v1alpha1"
	corev1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/typed/core/v1alpha1"
	tenancyv1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/typed/tenancy/v1alpha1"
	topologyv1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/typed/topology/v1alpha1"
)

// NewSimpleClientset returns a clientset that will respond with the provided objects.
// It's backed by a very simple object tracker that processes creates, updates and deletions as-is,
// without applying any field management, validations and/or defaults. It shouldn't be considered a replacement
// for a real clientset and is mostly useful in simple unit tests.
//
// DEPRECATED: NewClientset replaces this with support for field management, which significantly improves
// server side apply testing. NewClientset is only available when apply configurations are generated (e.g.
// via --with-applyconfig).
func NewSimpleClientset(objects ...runtime.Object) *ClusterClientset {
	o := kcptesting.NewObjectTracker(kcpclientscheme.Scheme, kcpclientscheme.Codecs.UniversalDecoder())
	o.AddAll(objects...)

	cs := &ClusterClientset{Fake: kcptesting.Fake{}, tracker: o}
	cs.discovery = &kcpfakediscovery.FakeDiscovery{Fake: &cs.Fake, ClusterPath: logicalcluster.Wildcard}
	cs.AddReactor("*", "*", kcptesting.ObjectReaction(o))
	cs.AddWatchReactor("*", kcptesting.WatchReaction(o))

	return cs
}

// ClusterClientset contains the clients for groups.
type ClusterClientset struct {
	kcptesting.Fake
	discovery *kcpfakediscovery.FakeDiscovery
	tracker   kcptesting.ObjectTracker
}

var _ kcpclientset.ClusterInterface = (*ClusterClientset)(nil)

// Discovery retrieves the DiscoveryClient
func (c *ClusterClientset) Discovery() discovery.DiscoveryInterface {
	return c.discovery
}

func (c *ClusterClientset) Tracker() kcptesting.ObjectTracker {
	return c.tracker
}

// Cluster scopes this clientset to one cluster.
func (c *ClusterClientset) Cluster(clusterPath logicalcluster.Path) clientset.Interface {
	if clusterPath == logicalcluster.Wildcard {
		panic("A specific cluster must be provided when scoping, not the wildcard.")
	}
	return &Clientset{
		Fake:        &c.Fake,
		discovery:   &kcpfakediscovery.FakeDiscovery{Fake: &c.Fake, ClusterPath: clusterPath},
		tracker:     c.tracker.Cluster(clusterPath),
		clusterPath: clusterPath,
	}
}

// ApisV1alpha1 retrieves the ApisV1alpha1ClusterClient
func (c *ClusterClientset) ApisV1alpha1() kcpapisv1alpha1.ApisV1alpha1ClusterInterface {
	return &kcpfakeapisv1alpha1.ApisV1alpha1ClusterClient{Fake: &c.Fake}
}

// ApisV1alpha2 retrieves the ApisV1alpha2ClusterClient
func (c *ClusterClientset) ApisV1alpha2() kcpapisv1alpha2.ApisV1alpha2ClusterInterface {
	return &kcpfakeapisv1alpha2.ApisV1alpha2ClusterClient{Fake: &c.Fake}
}

// CacheV1alpha1 retrieves the CacheV1alpha1ClusterClient
func (c *ClusterClientset) CacheV1alpha1() kcpcachev1alpha1.CacheV1alpha1ClusterInterface {
	return &kcpfakecachev1alpha1.CacheV1alpha1ClusterClient{Fake: &c.Fake}
}

// CoreV1alpha1 retrieves the CoreV1alpha1ClusterClient
func (c *ClusterClientset) CoreV1alpha1() kcpcorev1alpha1.CoreV1alpha1ClusterInterface {
	return &kcpfakecorev1alpha1.CoreV1alpha1ClusterClient{Fake: &c.Fake}
}

// TenancyV1alpha1 retrieves the TenancyV1alpha1ClusterClient
func (c *ClusterClientset) TenancyV1alpha1() kcptenancyv1alpha1.TenancyV1alpha1ClusterInterface {
	return &kcpfaketenancyv1alpha1.TenancyV1alpha1ClusterClient{Fake: &c.Fake}
}

// TopologyV1alpha1 retrieves the TopologyV1alpha1ClusterClient
func (c *ClusterClientset) TopologyV1alpha1() kcptopologyv1alpha1.TopologyV1alpha1ClusterInterface {
	return &kcpfaketopologyv1alpha1.TopologyV1alpha1ClusterClient{Fake: &c.Fake}
}

// Clientset implements clientset.Interface. Meant to be embedded into a
// struct to get a default implementation. This makes faking out just the method
// you want to test easier.
type Clientset struct {
	*kcptesting.Fake
	discovery   *kcpfakediscovery.FakeDiscovery
	tracker     kcptesting.ScopedObjectTracker
	clusterPath logicalcluster.Path
}

var (
	_ clientset.Interface         = &Clientset{}
	_ kcptesting.FakeScopedClient = &Clientset{}
)

func (c *Clientset) Discovery() discovery.DiscoveryInterface {
	return c.discovery
}

func (c *Clientset) Tracker() kcptesting.ScopedObjectTracker {
	return c.tracker
}

// NewClientset returns a clientset that will respond with the provided objects.
// It's backed by a very simple object tracker that processes creates, updates and deletions as-is,
// without applying any validations and/or defaults. It shouldn't be considered a replacement
// for a real clientset and is mostly useful in simple unit tests.
func NewClientset(objects ...runtime.Object) *ClusterClientset {
	o := kcptesting.NewFieldManagedObjectTracker(
		kcpclientscheme.Scheme,
		kcpclientscheme.Codecs.UniversalDecoder(),
		kcpapplyconfiguration.NewTypeConverter(kcpclientscheme.Scheme),
	)
	o.AddAll(objects...)

	cs := &ClusterClientset{Fake: kcptesting.Fake{}, tracker: o}
	cs.discovery = &kcpfakediscovery.FakeDiscovery{Fake: &cs.Fake, ClusterPath: logicalcluster.Wildcard}
	cs.AddReactor("*", "*", kcptesting.ObjectReaction(o))
	cs.AddWatchReactor("*", kcptesting.WatchReaction(o))

	return cs
}

// ApisV1alpha1 retrieves the ApisV1alpha1Client
func (c *Clientset) ApisV1alpha1() apisv1alpha1.ApisV1alpha1Interface {
	return &kcpfakeapisv1alpha1.ApisV1alpha1Client{Fake: c.Fake, ClusterPath: c.clusterPath}
}

// ApisV1alpha2 retrieves the ApisV1alpha2Client
func (c *Clientset) ApisV1alpha2() apisv1alpha2.ApisV1alpha2Interface {
	return &kcpfakeapisv1alpha2.ApisV1alpha2Client{Fake: c.Fake, ClusterPath: c.clusterPath}
}

// CacheV1alpha1 retrieves the CacheV1alpha1Client
func (c *Clientset) CacheV1alpha1() cachev1alpha1.CacheV1alpha1Interface {
	return &kcpfakecachev1alpha1.CacheV1alpha1Client{Fake: c.Fake, ClusterPath: c.clusterPath}
}

// CoreV1alpha1 retrieves the CoreV1alpha1Client
func (c *Clientset) CoreV1alpha1() corev1alpha1.CoreV1alpha1Interface {
	return &kcpfakecorev1alpha1.CoreV1alpha1Client{Fake: c.Fake, ClusterPath: c.clusterPath}
}

// TenancyV1alpha1 retrieves the TenancyV1alpha1Client
func (c *Clientset) TenancyV1alpha1() tenancyv1alpha1.TenancyV1alpha1Interface {
	return &kcpfaketenancyv1alpha1.TenancyV1alpha1Client{Fake: c.Fake, ClusterPath: c.clusterPath}
}

// TopologyV1alpha1 retrieves the TopologyV1alpha1Client
func (c *Clientset) TopologyV1alpha1() topologyv1alpha1.TopologyV1alpha1Interface {
	return &kcpfaketopologyv1alpha1.TopologyV1alpha1Client{Fake: c.Fake, ClusterPath: c.clusterPath}
}
