/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	tenancyv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/tenancy/v1alpha1"
)

// WorkspaceTypeSpecApplyConfiguration represents a declarative configuration of the WorkspaceTypeSpec type for use
// with apply.
type WorkspaceTypeSpecApplyConfiguration struct {
	Initializer                *bool                                     `json:"initializer,omitempty"`
	Extend                     *WorkspaceTypeExtensionApplyConfiguration `json:"extend,omitempty"`
	AdditionalWorkspaceLabels  map[string]string                         `json:"additionalWorkspaceLabels,omitempty"`
	DefaultChildWorkspaceType  *WorkspaceTypeReferenceApplyConfiguration `json:"defaultChildWorkspaceType,omitempty"`
	LimitAllowedChildren       *WorkspaceTypeSelectorApplyConfiguration  `json:"limitAllowedChildren,omitempty"`
	LimitAllowedParents        *WorkspaceTypeSelectorApplyConfiguration  `json:"limitAllowedParents,omitempty"`
	DefaultAPIBindings         []APIExportReferenceApplyConfiguration    `json:"defaultAPIBindings,omitempty"`
	DefaultAPIBindingLifecycle *tenancyv1alpha1.APIBindingLifecycleMode  `json:"defaultAPIBindingLifecycle,omitempty"`
}

// WorkspaceTypeSpecApplyConfiguration constructs a declarative configuration of the WorkspaceTypeSpec type for use with
// apply.
func WorkspaceTypeSpec() *WorkspaceTypeSpecApplyConfiguration {
	return &WorkspaceTypeSpecApplyConfiguration{}
}

// WithInitializer sets the Initializer field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Initializer field is set to the value of the last call.
func (b *WorkspaceTypeSpecApplyConfiguration) WithInitializer(value bool) *WorkspaceTypeSpecApplyConfiguration {
	b.Initializer = &value
	return b
}

// WithExtend sets the Extend field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Extend field is set to the value of the last call.
func (b *WorkspaceTypeSpecApplyConfiguration) WithExtend(value *WorkspaceTypeExtensionApplyConfiguration) *WorkspaceTypeSpecApplyConfiguration {
	b.Extend = value
	return b
}

// WithAdditionalWorkspaceLabels puts the entries into the AdditionalWorkspaceLabels field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the AdditionalWorkspaceLabels field,
// overwriting an existing map entries in AdditionalWorkspaceLabels field with the same key.
func (b *WorkspaceTypeSpecApplyConfiguration) WithAdditionalWorkspaceLabels(entries map[string]string) *WorkspaceTypeSpecApplyConfiguration {
	if b.AdditionalWorkspaceLabels == nil && len(entries) > 0 {
		b.AdditionalWorkspaceLabels = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.AdditionalWorkspaceLabels[k] = v
	}
	return b
}

// WithDefaultChildWorkspaceType sets the DefaultChildWorkspaceType field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DefaultChildWorkspaceType field is set to the value of the last call.
func (b *WorkspaceTypeSpecApplyConfiguration) WithDefaultChildWorkspaceType(value *WorkspaceTypeReferenceApplyConfiguration) *WorkspaceTypeSpecApplyConfiguration {
	b.DefaultChildWorkspaceType = value
	return b
}

// WithLimitAllowedChildren sets the LimitAllowedChildren field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LimitAllowedChildren field is set to the value of the last call.
func (b *WorkspaceTypeSpecApplyConfiguration) WithLimitAllowedChildren(value *WorkspaceTypeSelectorApplyConfiguration) *WorkspaceTypeSpecApplyConfiguration {
	b.LimitAllowedChildren = value
	return b
}

// WithLimitAllowedParents sets the LimitAllowedParents field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LimitAllowedParents field is set to the value of the last call.
func (b *WorkspaceTypeSpecApplyConfiguration) WithLimitAllowedParents(value *WorkspaceTypeSelectorApplyConfiguration) *WorkspaceTypeSpecApplyConfiguration {
	b.LimitAllowedParents = value
	return b
}

// WithDefaultAPIBindings adds the given value to the DefaultAPIBindings field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the DefaultAPIBindings field.
func (b *WorkspaceTypeSpecApplyConfiguration) WithDefaultAPIBindings(values ...*APIExportReferenceApplyConfiguration) *WorkspaceTypeSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithDefaultAPIBindings")
		}
		b.DefaultAPIBindings = append(b.DefaultAPIBindings, *values[i])
	}
	return b
}

// WithDefaultAPIBindingLifecycle sets the DefaultAPIBindingLifecycle field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DefaultAPIBindingLifecycle field is set to the value of the last call.
func (b *WorkspaceTypeSpecApplyConfiguration) WithDefaultAPIBindingLifecycle(value tenancyv1alpha1.APIBindingLifecycleMode) *WorkspaceTypeSpecApplyConfiguration {
	b.DefaultAPIBindingLifecycle = &value
	return b
}
