/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	corev1alpha1 "github.com/kcp-dev/kcp/sdk/apis/core/v1alpha1"
	conditionsv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/third_party/conditions/apis/conditions/v1alpha1"
)

// LogicalClusterStatusApplyConfiguration represents a declarative configuration of the LogicalClusterStatus type for use
// with apply.
type LogicalClusterStatusApplyConfiguration struct {
	URL          *string                                  `json:"URL,omitempty"`
	Phase        *corev1alpha1.LogicalClusterPhaseType    `json:"phase,omitempty"`
	Conditions   *conditionsv1alpha1.Conditions           `json:"conditions,omitempty"`
	Initializers []corev1alpha1.LogicalClusterInitializer `json:"initializers,omitempty"`
}

// LogicalClusterStatusApplyConfiguration constructs a declarative configuration of the LogicalClusterStatus type for use with
// apply.
func LogicalClusterStatus() *LogicalClusterStatusApplyConfiguration {
	return &LogicalClusterStatusApplyConfiguration{}
}

// WithURL sets the URL field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the URL field is set to the value of the last call.
func (b *LogicalClusterStatusApplyConfiguration) WithURL(value string) *LogicalClusterStatusApplyConfiguration {
	b.URL = &value
	return b
}

// WithPhase sets the Phase field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Phase field is set to the value of the last call.
func (b *LogicalClusterStatusApplyConfiguration) WithPhase(value corev1alpha1.LogicalClusterPhaseType) *LogicalClusterStatusApplyConfiguration {
	b.Phase = &value
	return b
}

// WithConditions sets the Conditions field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Conditions field is set to the value of the last call.
func (b *LogicalClusterStatusApplyConfiguration) WithConditions(value conditionsv1alpha1.Conditions) *LogicalClusterStatusApplyConfiguration {
	b.Conditions = &value
	return b
}

// WithInitializers adds the given value to the Initializers field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Initializers field.
func (b *LogicalClusterStatusApplyConfiguration) WithInitializers(values ...corev1alpha1.LogicalClusterInitializer) *LogicalClusterStatusApplyConfiguration {
	for i := range values {
		b.Initializers = append(b.Initializers, values[i])
	}
	return b
}
