/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	types "k8s.io/apimachinery/pkg/types"
)

// LogicalClusterOwnerApplyConfiguration represents a declarative configuration of the LogicalClusterOwner type for use
// with apply.
type LogicalClusterOwnerApplyConfiguration struct {
	APIVersion *string    `json:"apiVersion,omitempty"`
	Resource   *string    `json:"resource,omitempty"`
	Name       *string    `json:"name,omitempty"`
	Namespace  *string    `json:"namespace,omitempty"`
	Cluster    *string    `json:"cluster,omitempty"`
	UID        *types.UID `json:"uid,omitempty"`
}

// LogicalClusterOwnerApplyConfiguration constructs a declarative configuration of the LogicalClusterOwner type for use with
// apply.
func LogicalClusterOwner() *LogicalClusterOwnerApplyConfiguration {
	return &LogicalClusterOwnerApplyConfiguration{}
}

// WithAPIVersion sets the APIVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the APIVersion field is set to the value of the last call.
func (b *LogicalClusterOwnerApplyConfiguration) WithAPIVersion(value string) *LogicalClusterOwnerApplyConfiguration {
	b.APIVersion = &value
	return b
}

// WithResource sets the Resource field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Resource field is set to the value of the last call.
func (b *LogicalClusterOwnerApplyConfiguration) WithResource(value string) *LogicalClusterOwnerApplyConfiguration {
	b.Resource = &value
	return b
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *LogicalClusterOwnerApplyConfiguration) WithName(value string) *LogicalClusterOwnerApplyConfiguration {
	b.Name = &value
	return b
}

// WithNamespace sets the Namespace field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Namespace field is set to the value of the last call.
func (b *LogicalClusterOwnerApplyConfiguration) WithNamespace(value string) *LogicalClusterOwnerApplyConfiguration {
	b.Namespace = &value
	return b
}

// WithCluster sets the Cluster field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Cluster field is set to the value of the last call.
func (b *LogicalClusterOwnerApplyConfiguration) WithCluster(value string) *LogicalClusterOwnerApplyConfiguration {
	b.Cluster = &value
	return b
}

// WithUID sets the UID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the UID field is set to the value of the last call.
func (b *LogicalClusterOwnerApplyConfiguration) WithUID(value types.UID) *LogicalClusterOwnerApplyConfiguration {
	b.UID = &value
	return b
}
