/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	v1 "github.com/kcp-dev/kcp/sdk/client/applyconfiguration/meta/v1"
)

// CachedResourceSpecApplyConfiguration represents a declarative configuration of the CachedResourceSpec type for use
// with apply.
type CachedResourceSpecApplyConfiguration struct {
	GroupVersionResourceApplyConfiguration `json:",inline"`
	Identity                               *IdentityApplyConfiguration         `json:"identity,omitempty"`
	LabelSelector                          *v1.LabelSelectorApplyConfiguration `json:"labelSelector,omitempty"`
}

// CachedResourceSpecApplyConfiguration constructs a declarative configuration of the CachedResourceSpec type for use with
// apply.
func CachedResourceSpec() *CachedResourceSpecApplyConfiguration {
	return &CachedResourceSpecApplyConfiguration{}
}

// WithGroup sets the Group field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Group field is set to the value of the last call.
func (b *CachedResourceSpecApplyConfiguration) WithGroup(value string) *CachedResourceSpecApplyConfiguration {
	b.GroupVersionResourceApplyConfiguration.Group = &value
	return b
}

// WithVersion sets the Version field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Version field is set to the value of the last call.
func (b *CachedResourceSpecApplyConfiguration) WithVersion(value string) *CachedResourceSpecApplyConfiguration {
	b.GroupVersionResourceApplyConfiguration.Version = &value
	return b
}

// WithResource sets the Resource field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Resource field is set to the value of the last call.
func (b *CachedResourceSpecApplyConfiguration) WithResource(value string) *CachedResourceSpecApplyConfiguration {
	b.GroupVersionResourceApplyConfiguration.Resource = &value
	return b
}

// WithIdentity sets the Identity field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Identity field is set to the value of the last call.
func (b *CachedResourceSpecApplyConfiguration) WithIdentity(value *IdentityApplyConfiguration) *CachedResourceSpecApplyConfiguration {
	b.Identity = value
	return b
}

// WithLabelSelector sets the LabelSelector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LabelSelector field is set to the value of the last call.
func (b *CachedResourceSpecApplyConfiguration) WithLabelSelector(value *v1.LabelSelectorApplyConfiguration) *CachedResourceSpecApplyConfiguration {
	b.LabelSelector = value
	return b
}
