/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha2

// BoundAPIResourceApplyConfiguration represents a declarative configuration of the BoundAPIResource type for use
// with apply.
type BoundAPIResourceApplyConfiguration struct {
	Group           *string                                   `json:"group,omitempty"`
	Resource        *string                                   `json:"resource,omitempty"`
	Schema          *BoundAPIResourceSchemaApplyConfiguration `json:"schema,omitempty"`
	StorageVersions []string                                  `json:"storageVersions,omitempty"`
}

// BoundAPIResourceApplyConfiguration constructs a declarative configuration of the BoundAPIResource type for use with
// apply.
func BoundAPIResource() *BoundAPIResourceApplyConfiguration {
	return &BoundAPIResourceApplyConfiguration{}
}

// WithGroup sets the Group field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Group field is set to the value of the last call.
func (b *BoundAPIResourceApplyConfiguration) WithGroup(value string) *BoundAPIResourceApplyConfiguration {
	b.Group = &value
	return b
}

// WithResource sets the Resource field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Resource field is set to the value of the last call.
func (b *BoundAPIResourceApplyConfiguration) WithResource(value string) *BoundAPIResourceApplyConfiguration {
	b.Resource = &value
	return b
}

// WithSchema sets the Schema field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Schema field is set to the value of the last call.
func (b *BoundAPIResourceApplyConfiguration) WithSchema(value *BoundAPIResourceSchemaApplyConfiguration) *BoundAPIResourceApplyConfiguration {
	b.Schema = value
	return b
}

// WithStorageVersions adds the given value to the StorageVersions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the StorageVersions field.
func (b *BoundAPIResourceApplyConfiguration) WithStorageVersions(values ...string) *BoundAPIResourceApplyConfiguration {
	for i := range values {
		b.StorageVersions = append(b.StorageVersions, values[i])
	}
	return b
}
