/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

// APIBindingSpecApplyConfiguration represents a declarative configuration of the APIBindingSpec type for use
// with apply.
type APIBindingSpecApplyConfiguration struct {
	Reference        *BindingReferenceApplyConfiguration           `json:"reference,omitempty"`
	PermissionClaims []AcceptablePermissionClaimApplyConfiguration `json:"permissionClaims,omitempty"`
}

// APIBindingSpecApplyConfiguration constructs a declarative configuration of the APIBindingSpec type for use with
// apply.
func APIBindingSpec() *APIBindingSpecApplyConfiguration {
	return &APIBindingSpecApplyConfiguration{}
}

// WithReference sets the Reference field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Reference field is set to the value of the last call.
func (b *APIBindingSpecApplyConfiguration) WithReference(value *BindingReferenceApplyConfiguration) *APIBindingSpecApplyConfiguration {
	b.Reference = value
	return b
}

// WithPermissionClaims adds the given value to the PermissionClaims field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the PermissionClaims field.
func (b *APIBindingSpecApplyConfiguration) WithPermissionClaims(values ...*AcceptablePermissionClaimApplyConfiguration) *APIBindingSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithPermissionClaims")
		}
		b.PermissionClaims = append(b.PermissionClaims, *values[i])
	}
	return b
}
