//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1alpha2

import (
	unsafe "unsafe"

	v1 "k8s.io/api/core/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"

	v1alpha1 "github.com/kcp-dev/kcp/sdk/apis/apis/v1alpha1"
	conditionsv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/third_party/conditions/apis/conditions/v1alpha1"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*APIBindingList)(nil), (*v1alpha1.APIBindingList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_APIBindingList_To_v1alpha1_APIBindingList(a.(*APIBindingList), b.(*v1alpha1.APIBindingList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.APIBindingList)(nil), (*APIBindingList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_APIBindingList_To_v1alpha2_APIBindingList(a.(*v1alpha1.APIBindingList), b.(*APIBindingList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*APIBindingSpec)(nil), (*v1alpha1.APIBindingSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_APIBindingSpec_To_v1alpha1_APIBindingSpec(a.(*APIBindingSpec), b.(*v1alpha1.APIBindingSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.APIBindingSpec)(nil), (*APIBindingSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_APIBindingSpec_To_v1alpha2_APIBindingSpec(a.(*v1alpha1.APIBindingSpec), b.(*APIBindingSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*APIBindingStatus)(nil), (*v1alpha1.APIBindingStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_APIBindingStatus_To_v1alpha1_APIBindingStatus(a.(*APIBindingStatus), b.(*v1alpha1.APIBindingStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.APIBindingStatus)(nil), (*APIBindingStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_APIBindingStatus_To_v1alpha2_APIBindingStatus(a.(*v1alpha1.APIBindingStatus), b.(*APIBindingStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*APIExportList)(nil), (*v1alpha1.APIExportList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_APIExportList_To_v1alpha1_APIExportList(a.(*APIExportList), b.(*v1alpha1.APIExportList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.APIExportList)(nil), (*APIExportList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_APIExportList_To_v1alpha2_APIExportList(a.(*v1alpha1.APIExportList), b.(*APIExportList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*APIExportStatus)(nil), (*v1alpha1.APIExportStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_APIExportStatus_To_v1alpha1_APIExportStatus(a.(*APIExportStatus), b.(*v1alpha1.APIExportStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.APIExportStatus)(nil), (*APIExportStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_APIExportStatus_To_v1alpha2_APIExportStatus(a.(*v1alpha1.APIExportStatus), b.(*APIExportStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*BindingReference)(nil), (*v1alpha1.BindingReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_BindingReference_To_v1alpha1_BindingReference(a.(*BindingReference), b.(*v1alpha1.BindingReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.BindingReference)(nil), (*BindingReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_BindingReference_To_v1alpha2_BindingReference(a.(*v1alpha1.BindingReference), b.(*BindingReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*BoundAPIResource)(nil), (*v1alpha1.BoundAPIResource)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_BoundAPIResource_To_v1alpha1_BoundAPIResource(a.(*BoundAPIResource), b.(*v1alpha1.BoundAPIResource), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.BoundAPIResource)(nil), (*BoundAPIResource)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_BoundAPIResource_To_v1alpha2_BoundAPIResource(a.(*v1alpha1.BoundAPIResource), b.(*BoundAPIResource), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*BoundAPIResourceSchema)(nil), (*v1alpha1.BoundAPIResourceSchema)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_BoundAPIResourceSchema_To_v1alpha1_BoundAPIResourceSchema(a.(*BoundAPIResourceSchema), b.(*v1alpha1.BoundAPIResourceSchema), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.BoundAPIResourceSchema)(nil), (*BoundAPIResourceSchema)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_BoundAPIResourceSchema_To_v1alpha2_BoundAPIResourceSchema(a.(*v1alpha1.BoundAPIResourceSchema), b.(*BoundAPIResourceSchema), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ExportBindingReference)(nil), (*v1alpha1.ExportBindingReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ExportBindingReference_To_v1alpha1_ExportBindingReference(a.(*ExportBindingReference), b.(*v1alpha1.ExportBindingReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.ExportBindingReference)(nil), (*ExportBindingReference)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ExportBindingReference_To_v1alpha2_ExportBindingReference(a.(*v1alpha1.ExportBindingReference), b.(*ExportBindingReference), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*GroupResource)(nil), (*v1alpha1.GroupResource)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_GroupResource_To_v1alpha1_GroupResource(a.(*GroupResource), b.(*v1alpha1.GroupResource), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.GroupResource)(nil), (*GroupResource)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_GroupResource_To_v1alpha2_GroupResource(a.(*v1alpha1.GroupResource), b.(*GroupResource), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Identity)(nil), (*v1alpha1.Identity)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_Identity_To_v1alpha1_Identity(a.(*Identity), b.(*v1alpha1.Identity), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.Identity)(nil), (*Identity)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_Identity_To_v1alpha2_Identity(a.(*v1alpha1.Identity), b.(*Identity), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*LocalAPIExportPolicy)(nil), (*v1alpha1.LocalAPIExportPolicy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_LocalAPIExportPolicy_To_v1alpha1_LocalAPIExportPolicy(a.(*LocalAPIExportPolicy), b.(*v1alpha1.LocalAPIExportPolicy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.LocalAPIExportPolicy)(nil), (*LocalAPIExportPolicy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_LocalAPIExportPolicy_To_v1alpha2_LocalAPIExportPolicy(a.(*v1alpha1.LocalAPIExportPolicy), b.(*LocalAPIExportPolicy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*MaximalPermissionPolicy)(nil), (*v1alpha1.MaximalPermissionPolicy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_MaximalPermissionPolicy_To_v1alpha1_MaximalPermissionPolicy(a.(*MaximalPermissionPolicy), b.(*v1alpha1.MaximalPermissionPolicy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.MaximalPermissionPolicy)(nil), (*MaximalPermissionPolicy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_MaximalPermissionPolicy_To_v1alpha2_MaximalPermissionPolicy(a.(*v1alpha1.MaximalPermissionPolicy), b.(*MaximalPermissionPolicy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ResourceSelector)(nil), (*v1alpha1.ResourceSelector)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ResourceSelector_To_v1alpha1_ResourceSelector(a.(*ResourceSelector), b.(*v1alpha1.ResourceSelector), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.ResourceSelector)(nil), (*ResourceSelector)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ResourceSelector_To_v1alpha2_ResourceSelector(a.(*v1alpha1.ResourceSelector), b.(*ResourceSelector), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*VirtualWorkspace)(nil), (*v1alpha1.VirtualWorkspace)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_VirtualWorkspace_To_v1alpha1_VirtualWorkspace(a.(*VirtualWorkspace), b.(*v1alpha1.VirtualWorkspace), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha1.VirtualWorkspace)(nil), (*VirtualWorkspace)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_VirtualWorkspace_To_v1alpha2_VirtualWorkspace(a.(*v1alpha1.VirtualWorkspace), b.(*VirtualWorkspace), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1alpha1.APIBinding)(nil), (*APIBinding)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_APIBinding_To_v1alpha2_APIBinding(a.(*v1alpha1.APIBinding), b.(*APIBinding), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1alpha1.APIExportSpec)(nil), (*APIExportSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_APIExportSpec_To_v1alpha2_APIExportSpec(a.(*v1alpha1.APIExportSpec), b.(*APIExportSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1alpha1.APIExport)(nil), (*APIExport)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_APIExport_To_v1alpha2_APIExport(a.(*v1alpha1.APIExport), b.(*APIExport), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1alpha1.AcceptablePermissionClaim)(nil), (*AcceptablePermissionClaim)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_AcceptablePermissionClaim_To_v1alpha2_AcceptablePermissionClaim(a.(*v1alpha1.AcceptablePermissionClaim), b.(*AcceptablePermissionClaim), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1alpha1.PermissionClaim)(nil), (*PermissionClaim)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_PermissionClaim_To_v1alpha2_PermissionClaim(a.(*v1alpha1.PermissionClaim), b.(*PermissionClaim), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1alpha1.PermissionClaim)(nil), (*ScopedPermissionClaim)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_PermissionClaim_To_v1alpha2_ScopedPermissionClaim(a.(*v1alpha1.PermissionClaim), b.(*ScopedPermissionClaim), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*APIBinding)(nil), (*v1alpha1.APIBinding)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_APIBinding_To_v1alpha1_APIBinding(a.(*APIBinding), b.(*v1alpha1.APIBinding), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*APIExportSpec)(nil), (*v1alpha1.APIExportSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_APIExportSpec_To_v1alpha1_APIExportSpec(a.(*APIExportSpec), b.(*v1alpha1.APIExportSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*APIExport)(nil), (*v1alpha1.APIExport)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_APIExport_To_v1alpha1_APIExport(a.(*APIExport), b.(*v1alpha1.APIExport), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*AcceptablePermissionClaim)(nil), (*v1alpha1.AcceptablePermissionClaim)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_AcceptablePermissionClaim_To_v1alpha1_AcceptablePermissionClaim(a.(*AcceptablePermissionClaim), b.(*v1alpha1.AcceptablePermissionClaim), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*PermissionClaim)(nil), (*v1alpha1.PermissionClaim)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_PermissionClaim_To_v1alpha1_PermissionClaim(a.(*PermissionClaim), b.(*v1alpha1.PermissionClaim), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*ScopedPermissionClaim)(nil), (*v1alpha1.PermissionClaim)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ScopedPermissionClaim_To_v1alpha1_PermissionClaim(a.(*ScopedPermissionClaim), b.(*v1alpha1.PermissionClaim), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha2_APIBinding_To_v1alpha1_APIBinding(in *APIBinding, out *v1alpha1.APIBinding, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha2_APIBindingSpec_To_v1alpha1_APIBindingSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha2_APIBindingStatus_To_v1alpha1_APIBindingStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha1_APIBinding_To_v1alpha2_APIBinding(in *v1alpha1.APIBinding, out *APIBinding, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_APIBindingSpec_To_v1alpha2_APIBindingSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_APIBindingStatus_To_v1alpha2_APIBindingStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha2_APIBindingList_To_v1alpha1_APIBindingList(in *APIBindingList, out *v1alpha1.APIBindingList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1alpha1.APIBinding, len(*in))
		for i := range *in {
			if err := Convert_v1alpha2_APIBinding_To_v1alpha1_APIBinding(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha2_APIBindingList_To_v1alpha1_APIBindingList is an autogenerated conversion function.
func Convert_v1alpha2_APIBindingList_To_v1alpha1_APIBindingList(in *APIBindingList, out *v1alpha1.APIBindingList, s conversion.Scope) error {
	return autoConvert_v1alpha2_APIBindingList_To_v1alpha1_APIBindingList(in, out, s)
}

func autoConvert_v1alpha1_APIBindingList_To_v1alpha2_APIBindingList(in *v1alpha1.APIBindingList, out *APIBindingList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]APIBinding, len(*in))
		for i := range *in {
			if err := Convert_v1alpha1_APIBinding_To_v1alpha2_APIBinding(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha1_APIBindingList_To_v1alpha2_APIBindingList is an autogenerated conversion function.
func Convert_v1alpha1_APIBindingList_To_v1alpha2_APIBindingList(in *v1alpha1.APIBindingList, out *APIBindingList, s conversion.Scope) error {
	return autoConvert_v1alpha1_APIBindingList_To_v1alpha2_APIBindingList(in, out, s)
}

func autoConvert_v1alpha2_APIBindingSpec_To_v1alpha1_APIBindingSpec(in *APIBindingSpec, out *v1alpha1.APIBindingSpec, s conversion.Scope) error {
	if err := Convert_v1alpha2_BindingReference_To_v1alpha1_BindingReference(&in.Reference, &out.Reference, s); err != nil {
		return err
	}
	if in.PermissionClaims != nil {
		in, out := &in.PermissionClaims, &out.PermissionClaims
		*out = make([]v1alpha1.AcceptablePermissionClaim, len(*in))
		for i := range *in {
			if err := Convert_v1alpha2_AcceptablePermissionClaim_To_v1alpha1_AcceptablePermissionClaim(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.PermissionClaims = nil
	}
	return nil
}

// Convert_v1alpha2_APIBindingSpec_To_v1alpha1_APIBindingSpec is an autogenerated conversion function.
func Convert_v1alpha2_APIBindingSpec_To_v1alpha1_APIBindingSpec(in *APIBindingSpec, out *v1alpha1.APIBindingSpec, s conversion.Scope) error {
	return autoConvert_v1alpha2_APIBindingSpec_To_v1alpha1_APIBindingSpec(in, out, s)
}

func autoConvert_v1alpha1_APIBindingSpec_To_v1alpha2_APIBindingSpec(in *v1alpha1.APIBindingSpec, out *APIBindingSpec, s conversion.Scope) error {
	if err := Convert_v1alpha1_BindingReference_To_v1alpha2_BindingReference(&in.Reference, &out.Reference, s); err != nil {
		return err
	}
	if in.PermissionClaims != nil {
		in, out := &in.PermissionClaims, &out.PermissionClaims
		*out = make([]AcceptablePermissionClaim, len(*in))
		for i := range *in {
			if err := Convert_v1alpha1_AcceptablePermissionClaim_To_v1alpha2_AcceptablePermissionClaim(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.PermissionClaims = nil
	}
	return nil
}

// Convert_v1alpha1_APIBindingSpec_To_v1alpha2_APIBindingSpec is an autogenerated conversion function.
func Convert_v1alpha1_APIBindingSpec_To_v1alpha2_APIBindingSpec(in *v1alpha1.APIBindingSpec, out *APIBindingSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_APIBindingSpec_To_v1alpha2_APIBindingSpec(in, out, s)
}

func autoConvert_v1alpha2_APIBindingStatus_To_v1alpha1_APIBindingStatus(in *APIBindingStatus, out *v1alpha1.APIBindingStatus, s conversion.Scope) error {
	out.APIExportClusterName = in.APIExportClusterName
	out.BoundResources = *(*[]v1alpha1.BoundAPIResource)(unsafe.Pointer(&in.BoundResources))
	out.Phase = v1alpha1.APIBindingPhaseType(in.Phase)
	out.Conditions = *(*conditionsv1alpha1.Conditions)(unsafe.Pointer(&in.Conditions))
	if in.AppliedPermissionClaims != nil {
		in, out := &in.AppliedPermissionClaims, &out.AppliedPermissionClaims
		*out = make([]v1alpha1.PermissionClaim, len(*in))
		for i := range *in {
			if err := Convert_v1alpha2_ScopedPermissionClaim_To_v1alpha1_PermissionClaim(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.AppliedPermissionClaims = nil
	}
	if in.ExportPermissionClaims != nil {
		in, out := &in.ExportPermissionClaims, &out.ExportPermissionClaims
		*out = make([]v1alpha1.PermissionClaim, len(*in))
		for i := range *in {
			if err := Convert_v1alpha2_PermissionClaim_To_v1alpha1_PermissionClaim(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.ExportPermissionClaims = nil
	}
	return nil
}

// Convert_v1alpha2_APIBindingStatus_To_v1alpha1_APIBindingStatus is an autogenerated conversion function.
func Convert_v1alpha2_APIBindingStatus_To_v1alpha1_APIBindingStatus(in *APIBindingStatus, out *v1alpha1.APIBindingStatus, s conversion.Scope) error {
	return autoConvert_v1alpha2_APIBindingStatus_To_v1alpha1_APIBindingStatus(in, out, s)
}

func autoConvert_v1alpha1_APIBindingStatus_To_v1alpha2_APIBindingStatus(in *v1alpha1.APIBindingStatus, out *APIBindingStatus, s conversion.Scope) error {
	out.APIExportClusterName = in.APIExportClusterName
	out.BoundResources = *(*[]BoundAPIResource)(unsafe.Pointer(&in.BoundResources))
	out.Phase = APIBindingPhaseType(in.Phase)
	out.Conditions = *(*conditionsv1alpha1.Conditions)(unsafe.Pointer(&in.Conditions))
	if in.AppliedPermissionClaims != nil {
		in, out := &in.AppliedPermissionClaims, &out.AppliedPermissionClaims
		*out = make([]ScopedPermissionClaim, len(*in))
		for i := range *in {
			if err := Convert_v1alpha1_PermissionClaim_To_v1alpha2_ScopedPermissionClaim(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.AppliedPermissionClaims = nil
	}
	if in.ExportPermissionClaims != nil {
		in, out := &in.ExportPermissionClaims, &out.ExportPermissionClaims
		*out = make([]PermissionClaim, len(*in))
		for i := range *in {
			if err := Convert_v1alpha1_PermissionClaim_To_v1alpha2_PermissionClaim(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.ExportPermissionClaims = nil
	}
	return nil
}

// Convert_v1alpha1_APIBindingStatus_To_v1alpha2_APIBindingStatus is an autogenerated conversion function.
func Convert_v1alpha1_APIBindingStatus_To_v1alpha2_APIBindingStatus(in *v1alpha1.APIBindingStatus, out *APIBindingStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_APIBindingStatus_To_v1alpha2_APIBindingStatus(in, out, s)
}

func autoConvert_v1alpha2_APIExport_To_v1alpha1_APIExport(in *APIExport, out *v1alpha1.APIExport, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha2_APIExportSpec_To_v1alpha1_APIExportSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha2_APIExportStatus_To_v1alpha1_APIExportStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha1_APIExport_To_v1alpha2_APIExport(in *v1alpha1.APIExport, out *APIExport, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_APIExportSpec_To_v1alpha2_APIExportSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_APIExportStatus_To_v1alpha2_APIExportStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha2_APIExportList_To_v1alpha1_APIExportList(in *APIExportList, out *v1alpha1.APIExportList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1alpha1.APIExport, len(*in))
		for i := range *in {
			if err := Convert_v1alpha2_APIExport_To_v1alpha1_APIExport(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha2_APIExportList_To_v1alpha1_APIExportList is an autogenerated conversion function.
func Convert_v1alpha2_APIExportList_To_v1alpha1_APIExportList(in *APIExportList, out *v1alpha1.APIExportList, s conversion.Scope) error {
	return autoConvert_v1alpha2_APIExportList_To_v1alpha1_APIExportList(in, out, s)
}

func autoConvert_v1alpha1_APIExportList_To_v1alpha2_APIExportList(in *v1alpha1.APIExportList, out *APIExportList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]APIExport, len(*in))
		for i := range *in {
			if err := Convert_v1alpha1_APIExport_To_v1alpha2_APIExport(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha1_APIExportList_To_v1alpha2_APIExportList is an autogenerated conversion function.
func Convert_v1alpha1_APIExportList_To_v1alpha2_APIExportList(in *v1alpha1.APIExportList, out *APIExportList, s conversion.Scope) error {
	return autoConvert_v1alpha1_APIExportList_To_v1alpha2_APIExportList(in, out, s)
}

func autoConvert_v1alpha2_APIExportSpec_To_v1alpha1_APIExportSpec(in *APIExportSpec, out *v1alpha1.APIExportSpec, s conversion.Scope) error {
	// WARNING: in.Resources requires manual conversion: does not exist in peer-type
	out.Identity = (*v1alpha1.Identity)(unsafe.Pointer(in.Identity))
	out.MaximalPermissionPolicy = (*v1alpha1.MaximalPermissionPolicy)(unsafe.Pointer(in.MaximalPermissionPolicy))
	if in.PermissionClaims != nil {
		in, out := &in.PermissionClaims, &out.PermissionClaims
		*out = make([]v1alpha1.PermissionClaim, len(*in))
		for i := range *in {
			if err := Convert_v1alpha2_PermissionClaim_To_v1alpha1_PermissionClaim(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.PermissionClaims = nil
	}
	return nil
}

func autoConvert_v1alpha1_APIExportSpec_To_v1alpha2_APIExportSpec(in *v1alpha1.APIExportSpec, out *APIExportSpec, s conversion.Scope) error {
	// WARNING: in.LatestResourceSchemas requires manual conversion: does not exist in peer-type
	out.Identity = (*Identity)(unsafe.Pointer(in.Identity))
	out.MaximalPermissionPolicy = (*MaximalPermissionPolicy)(unsafe.Pointer(in.MaximalPermissionPolicy))
	if in.PermissionClaims != nil {
		in, out := &in.PermissionClaims, &out.PermissionClaims
		*out = make([]PermissionClaim, len(*in))
		for i := range *in {
			if err := Convert_v1alpha1_PermissionClaim_To_v1alpha2_PermissionClaim(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.PermissionClaims = nil
	}
	return nil
}

func autoConvert_v1alpha2_APIExportStatus_To_v1alpha1_APIExportStatus(in *APIExportStatus, out *v1alpha1.APIExportStatus, s conversion.Scope) error {
	out.IdentityHash = in.IdentityHash
	out.Conditions = *(*conditionsv1alpha1.Conditions)(unsafe.Pointer(&in.Conditions))
	out.VirtualWorkspaces = *(*[]v1alpha1.VirtualWorkspace)(unsafe.Pointer(&in.VirtualWorkspaces))
	return nil
}

// Convert_v1alpha2_APIExportStatus_To_v1alpha1_APIExportStatus is an autogenerated conversion function.
func Convert_v1alpha2_APIExportStatus_To_v1alpha1_APIExportStatus(in *APIExportStatus, out *v1alpha1.APIExportStatus, s conversion.Scope) error {
	return autoConvert_v1alpha2_APIExportStatus_To_v1alpha1_APIExportStatus(in, out, s)
}

func autoConvert_v1alpha1_APIExportStatus_To_v1alpha2_APIExportStatus(in *v1alpha1.APIExportStatus, out *APIExportStatus, s conversion.Scope) error {
	out.IdentityHash = in.IdentityHash
	out.Conditions = *(*conditionsv1alpha1.Conditions)(unsafe.Pointer(&in.Conditions))
	out.VirtualWorkspaces = *(*[]VirtualWorkspace)(unsafe.Pointer(&in.VirtualWorkspaces))
	return nil
}

// Convert_v1alpha1_APIExportStatus_To_v1alpha2_APIExportStatus is an autogenerated conversion function.
func Convert_v1alpha1_APIExportStatus_To_v1alpha2_APIExportStatus(in *v1alpha1.APIExportStatus, out *APIExportStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_APIExportStatus_To_v1alpha2_APIExportStatus(in, out, s)
}

func autoConvert_v1alpha2_AcceptablePermissionClaim_To_v1alpha1_AcceptablePermissionClaim(in *AcceptablePermissionClaim, out *v1alpha1.AcceptablePermissionClaim, s conversion.Scope) error {
	// WARNING: in.ScopedPermissionClaim requires manual conversion: does not exist in peer-type
	out.State = v1alpha1.AcceptablePermissionClaimState(in.State)
	return nil
}

func autoConvert_v1alpha1_AcceptablePermissionClaim_To_v1alpha2_AcceptablePermissionClaim(in *v1alpha1.AcceptablePermissionClaim, out *AcceptablePermissionClaim, s conversion.Scope) error {
	// WARNING: in.PermissionClaim requires manual conversion: does not exist in peer-type
	out.State = AcceptablePermissionClaimState(in.State)
	return nil
}

func autoConvert_v1alpha2_BindingReference_To_v1alpha1_BindingReference(in *BindingReference, out *v1alpha1.BindingReference, s conversion.Scope) error {
	out.Export = (*v1alpha1.ExportBindingReference)(unsafe.Pointer(in.Export))
	return nil
}

// Convert_v1alpha2_BindingReference_To_v1alpha1_BindingReference is an autogenerated conversion function.
func Convert_v1alpha2_BindingReference_To_v1alpha1_BindingReference(in *BindingReference, out *v1alpha1.BindingReference, s conversion.Scope) error {
	return autoConvert_v1alpha2_BindingReference_To_v1alpha1_BindingReference(in, out, s)
}

func autoConvert_v1alpha1_BindingReference_To_v1alpha2_BindingReference(in *v1alpha1.BindingReference, out *BindingReference, s conversion.Scope) error {
	out.Export = (*ExportBindingReference)(unsafe.Pointer(in.Export))
	return nil
}

// Convert_v1alpha1_BindingReference_To_v1alpha2_BindingReference is an autogenerated conversion function.
func Convert_v1alpha1_BindingReference_To_v1alpha2_BindingReference(in *v1alpha1.BindingReference, out *BindingReference, s conversion.Scope) error {
	return autoConvert_v1alpha1_BindingReference_To_v1alpha2_BindingReference(in, out, s)
}

func autoConvert_v1alpha2_BoundAPIResource_To_v1alpha1_BoundAPIResource(in *BoundAPIResource, out *v1alpha1.BoundAPIResource, s conversion.Scope) error {
	out.Group = in.Group
	out.Resource = in.Resource
	if err := Convert_v1alpha2_BoundAPIResourceSchema_To_v1alpha1_BoundAPIResourceSchema(&in.Schema, &out.Schema, s); err != nil {
		return err
	}
	out.StorageVersions = *(*[]string)(unsafe.Pointer(&in.StorageVersions))
	return nil
}

// Convert_v1alpha2_BoundAPIResource_To_v1alpha1_BoundAPIResource is an autogenerated conversion function.
func Convert_v1alpha2_BoundAPIResource_To_v1alpha1_BoundAPIResource(in *BoundAPIResource, out *v1alpha1.BoundAPIResource, s conversion.Scope) error {
	return autoConvert_v1alpha2_BoundAPIResource_To_v1alpha1_BoundAPIResource(in, out, s)
}

func autoConvert_v1alpha1_BoundAPIResource_To_v1alpha2_BoundAPIResource(in *v1alpha1.BoundAPIResource, out *BoundAPIResource, s conversion.Scope) error {
	out.Group = in.Group
	out.Resource = in.Resource
	if err := Convert_v1alpha1_BoundAPIResourceSchema_To_v1alpha2_BoundAPIResourceSchema(&in.Schema, &out.Schema, s); err != nil {
		return err
	}
	out.StorageVersions = *(*[]string)(unsafe.Pointer(&in.StorageVersions))
	return nil
}

// Convert_v1alpha1_BoundAPIResource_To_v1alpha2_BoundAPIResource is an autogenerated conversion function.
func Convert_v1alpha1_BoundAPIResource_To_v1alpha2_BoundAPIResource(in *v1alpha1.BoundAPIResource, out *BoundAPIResource, s conversion.Scope) error {
	return autoConvert_v1alpha1_BoundAPIResource_To_v1alpha2_BoundAPIResource(in, out, s)
}

func autoConvert_v1alpha2_BoundAPIResourceSchema_To_v1alpha1_BoundAPIResourceSchema(in *BoundAPIResourceSchema, out *v1alpha1.BoundAPIResourceSchema, s conversion.Scope) error {
	out.Name = in.Name
	out.UID = in.UID
	out.IdentityHash = in.IdentityHash
	return nil
}

// Convert_v1alpha2_BoundAPIResourceSchema_To_v1alpha1_BoundAPIResourceSchema is an autogenerated conversion function.
func Convert_v1alpha2_BoundAPIResourceSchema_To_v1alpha1_BoundAPIResourceSchema(in *BoundAPIResourceSchema, out *v1alpha1.BoundAPIResourceSchema, s conversion.Scope) error {
	return autoConvert_v1alpha2_BoundAPIResourceSchema_To_v1alpha1_BoundAPIResourceSchema(in, out, s)
}

func autoConvert_v1alpha1_BoundAPIResourceSchema_To_v1alpha2_BoundAPIResourceSchema(in *v1alpha1.BoundAPIResourceSchema, out *BoundAPIResourceSchema, s conversion.Scope) error {
	out.Name = in.Name
	out.UID = in.UID
	out.IdentityHash = in.IdentityHash
	return nil
}

// Convert_v1alpha1_BoundAPIResourceSchema_To_v1alpha2_BoundAPIResourceSchema is an autogenerated conversion function.
func Convert_v1alpha1_BoundAPIResourceSchema_To_v1alpha2_BoundAPIResourceSchema(in *v1alpha1.BoundAPIResourceSchema, out *BoundAPIResourceSchema, s conversion.Scope) error {
	return autoConvert_v1alpha1_BoundAPIResourceSchema_To_v1alpha2_BoundAPIResourceSchema(in, out, s)
}

func autoConvert_v1alpha2_ExportBindingReference_To_v1alpha1_ExportBindingReference(in *ExportBindingReference, out *v1alpha1.ExportBindingReference, s conversion.Scope) error {
	out.Path = in.Path
	out.Name = in.Name
	return nil
}

// Convert_v1alpha2_ExportBindingReference_To_v1alpha1_ExportBindingReference is an autogenerated conversion function.
func Convert_v1alpha2_ExportBindingReference_To_v1alpha1_ExportBindingReference(in *ExportBindingReference, out *v1alpha1.ExportBindingReference, s conversion.Scope) error {
	return autoConvert_v1alpha2_ExportBindingReference_To_v1alpha1_ExportBindingReference(in, out, s)
}

func autoConvert_v1alpha1_ExportBindingReference_To_v1alpha2_ExportBindingReference(in *v1alpha1.ExportBindingReference, out *ExportBindingReference, s conversion.Scope) error {
	out.Path = in.Path
	out.Name = in.Name
	return nil
}

// Convert_v1alpha1_ExportBindingReference_To_v1alpha2_ExportBindingReference is an autogenerated conversion function.
func Convert_v1alpha1_ExportBindingReference_To_v1alpha2_ExportBindingReference(in *v1alpha1.ExportBindingReference, out *ExportBindingReference, s conversion.Scope) error {
	return autoConvert_v1alpha1_ExportBindingReference_To_v1alpha2_ExportBindingReference(in, out, s)
}

func autoConvert_v1alpha2_GroupResource_To_v1alpha1_GroupResource(in *GroupResource, out *v1alpha1.GroupResource, s conversion.Scope) error {
	out.Group = in.Group
	out.Resource = in.Resource
	return nil
}

// Convert_v1alpha2_GroupResource_To_v1alpha1_GroupResource is an autogenerated conversion function.
func Convert_v1alpha2_GroupResource_To_v1alpha1_GroupResource(in *GroupResource, out *v1alpha1.GroupResource, s conversion.Scope) error {
	return autoConvert_v1alpha2_GroupResource_To_v1alpha1_GroupResource(in, out, s)
}

func autoConvert_v1alpha1_GroupResource_To_v1alpha2_GroupResource(in *v1alpha1.GroupResource, out *GroupResource, s conversion.Scope) error {
	out.Group = in.Group
	out.Resource = in.Resource
	return nil
}

// Convert_v1alpha1_GroupResource_To_v1alpha2_GroupResource is an autogenerated conversion function.
func Convert_v1alpha1_GroupResource_To_v1alpha2_GroupResource(in *v1alpha1.GroupResource, out *GroupResource, s conversion.Scope) error {
	return autoConvert_v1alpha1_GroupResource_To_v1alpha2_GroupResource(in, out, s)
}

func autoConvert_v1alpha2_Identity_To_v1alpha1_Identity(in *Identity, out *v1alpha1.Identity, s conversion.Scope) error {
	out.SecretRef = (*v1.SecretReference)(unsafe.Pointer(in.SecretRef))
	return nil
}

// Convert_v1alpha2_Identity_To_v1alpha1_Identity is an autogenerated conversion function.
func Convert_v1alpha2_Identity_To_v1alpha1_Identity(in *Identity, out *v1alpha1.Identity, s conversion.Scope) error {
	return autoConvert_v1alpha2_Identity_To_v1alpha1_Identity(in, out, s)
}

func autoConvert_v1alpha1_Identity_To_v1alpha2_Identity(in *v1alpha1.Identity, out *Identity, s conversion.Scope) error {
	out.SecretRef = (*v1.SecretReference)(unsafe.Pointer(in.SecretRef))
	return nil
}

// Convert_v1alpha1_Identity_To_v1alpha2_Identity is an autogenerated conversion function.
func Convert_v1alpha1_Identity_To_v1alpha2_Identity(in *v1alpha1.Identity, out *Identity, s conversion.Scope) error {
	return autoConvert_v1alpha1_Identity_To_v1alpha2_Identity(in, out, s)
}

func autoConvert_v1alpha2_LocalAPIExportPolicy_To_v1alpha1_LocalAPIExportPolicy(in *LocalAPIExportPolicy, out *v1alpha1.LocalAPIExportPolicy, s conversion.Scope) error {
	return nil
}

// Convert_v1alpha2_LocalAPIExportPolicy_To_v1alpha1_LocalAPIExportPolicy is an autogenerated conversion function.
func Convert_v1alpha2_LocalAPIExportPolicy_To_v1alpha1_LocalAPIExportPolicy(in *LocalAPIExportPolicy, out *v1alpha1.LocalAPIExportPolicy, s conversion.Scope) error {
	return autoConvert_v1alpha2_LocalAPIExportPolicy_To_v1alpha1_LocalAPIExportPolicy(in, out, s)
}

func autoConvert_v1alpha1_LocalAPIExportPolicy_To_v1alpha2_LocalAPIExportPolicy(in *v1alpha1.LocalAPIExportPolicy, out *LocalAPIExportPolicy, s conversion.Scope) error {
	return nil
}

// Convert_v1alpha1_LocalAPIExportPolicy_To_v1alpha2_LocalAPIExportPolicy is an autogenerated conversion function.
func Convert_v1alpha1_LocalAPIExportPolicy_To_v1alpha2_LocalAPIExportPolicy(in *v1alpha1.LocalAPIExportPolicy, out *LocalAPIExportPolicy, s conversion.Scope) error {
	return autoConvert_v1alpha1_LocalAPIExportPolicy_To_v1alpha2_LocalAPIExportPolicy(in, out, s)
}

func autoConvert_v1alpha2_MaximalPermissionPolicy_To_v1alpha1_MaximalPermissionPolicy(in *MaximalPermissionPolicy, out *v1alpha1.MaximalPermissionPolicy, s conversion.Scope) error {
	out.Local = (*v1alpha1.LocalAPIExportPolicy)(unsafe.Pointer(in.Local))
	return nil
}

// Convert_v1alpha2_MaximalPermissionPolicy_To_v1alpha1_MaximalPermissionPolicy is an autogenerated conversion function.
func Convert_v1alpha2_MaximalPermissionPolicy_To_v1alpha1_MaximalPermissionPolicy(in *MaximalPermissionPolicy, out *v1alpha1.MaximalPermissionPolicy, s conversion.Scope) error {
	return autoConvert_v1alpha2_MaximalPermissionPolicy_To_v1alpha1_MaximalPermissionPolicy(in, out, s)
}

func autoConvert_v1alpha1_MaximalPermissionPolicy_To_v1alpha2_MaximalPermissionPolicy(in *v1alpha1.MaximalPermissionPolicy, out *MaximalPermissionPolicy, s conversion.Scope) error {
	out.Local = (*LocalAPIExportPolicy)(unsafe.Pointer(in.Local))
	return nil
}

// Convert_v1alpha1_MaximalPermissionPolicy_To_v1alpha2_MaximalPermissionPolicy is an autogenerated conversion function.
func Convert_v1alpha1_MaximalPermissionPolicy_To_v1alpha2_MaximalPermissionPolicy(in *v1alpha1.MaximalPermissionPolicy, out *MaximalPermissionPolicy, s conversion.Scope) error {
	return autoConvert_v1alpha1_MaximalPermissionPolicy_To_v1alpha2_MaximalPermissionPolicy(in, out, s)
}

func autoConvert_v1alpha2_PermissionClaim_To_v1alpha1_PermissionClaim(in *PermissionClaim, out *v1alpha1.PermissionClaim, s conversion.Scope) error {
	if err := Convert_v1alpha2_GroupResource_To_v1alpha1_GroupResource(&in.GroupResource, &out.GroupResource, s); err != nil {
		return err
	}
	// WARNING: in.Verbs requires manual conversion: does not exist in peer-type
	out.IdentityHash = in.IdentityHash
	return nil
}

func autoConvert_v1alpha1_PermissionClaim_To_v1alpha2_PermissionClaim(in *v1alpha1.PermissionClaim, out *PermissionClaim, s conversion.Scope) error {
	if err := Convert_v1alpha1_GroupResource_To_v1alpha2_GroupResource(&in.GroupResource, &out.GroupResource, s); err != nil {
		return err
	}
	// WARNING: in.All requires manual conversion: does not exist in peer-type
	// WARNING: in.ResourceSelector requires manual conversion: does not exist in peer-type
	out.IdentityHash = in.IdentityHash
	return nil
}

func autoConvert_v1alpha2_ResourceSelector_To_v1alpha1_ResourceSelector(in *ResourceSelector, out *v1alpha1.ResourceSelector, s conversion.Scope) error {
	out.Name = in.Name
	out.Namespace = in.Namespace
	return nil
}

// Convert_v1alpha2_ResourceSelector_To_v1alpha1_ResourceSelector is an autogenerated conversion function.
func Convert_v1alpha2_ResourceSelector_To_v1alpha1_ResourceSelector(in *ResourceSelector, out *v1alpha1.ResourceSelector, s conversion.Scope) error {
	return autoConvert_v1alpha2_ResourceSelector_To_v1alpha1_ResourceSelector(in, out, s)
}

func autoConvert_v1alpha1_ResourceSelector_To_v1alpha2_ResourceSelector(in *v1alpha1.ResourceSelector, out *ResourceSelector, s conversion.Scope) error {
	out.Name = in.Name
	out.Namespace = in.Namespace
	return nil
}

// Convert_v1alpha1_ResourceSelector_To_v1alpha2_ResourceSelector is an autogenerated conversion function.
func Convert_v1alpha1_ResourceSelector_To_v1alpha2_ResourceSelector(in *v1alpha1.ResourceSelector, out *ResourceSelector, s conversion.Scope) error {
	return autoConvert_v1alpha1_ResourceSelector_To_v1alpha2_ResourceSelector(in, out, s)
}

func autoConvert_v1alpha2_VirtualWorkspace_To_v1alpha1_VirtualWorkspace(in *VirtualWorkspace, out *v1alpha1.VirtualWorkspace, s conversion.Scope) error {
	out.URL = in.URL
	return nil
}

// Convert_v1alpha2_VirtualWorkspace_To_v1alpha1_VirtualWorkspace is an autogenerated conversion function.
func Convert_v1alpha2_VirtualWorkspace_To_v1alpha1_VirtualWorkspace(in *VirtualWorkspace, out *v1alpha1.VirtualWorkspace, s conversion.Scope) error {
	return autoConvert_v1alpha2_VirtualWorkspace_To_v1alpha1_VirtualWorkspace(in, out, s)
}

func autoConvert_v1alpha1_VirtualWorkspace_To_v1alpha2_VirtualWorkspace(in *v1alpha1.VirtualWorkspace, out *VirtualWorkspace, s conversion.Scope) error {
	out.URL = in.URL
	return nil
}

// Convert_v1alpha1_VirtualWorkspace_To_v1alpha2_VirtualWorkspace is an autogenerated conversion function.
func Convert_v1alpha1_VirtualWorkspace_To_v1alpha2_VirtualWorkspace(in *v1alpha1.VirtualWorkspace, out *VirtualWorkspace, s conversion.Scope) error {
	return autoConvert_v1alpha1_VirtualWorkspace_To_v1alpha2_VirtualWorkspace(in, out, s)
}
