/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"

	kcplisters "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/listers"
	"github.com/kcp-dev/logicalcluster/v3"

	kcpv1alpha1 "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/apis/wildwest/v1alpha1"
)

// SheriffClusterLister helps list Sherifves across all workspaces,
// or scope down to a SheriffLister for one workspace.
// All objects returned here must be treated as read-only.
type SheriffClusterLister interface {
	// List lists all Sherifves in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.Sheriff, err error)
	// Cluster returns a lister that can list and get Sherifves in one workspace.
	Cluster(clusterName logicalcluster.Name) SheriffLister
	SheriffClusterListerExpansion
}

// sheriffClusterLister implements the SheriffClusterLister interface.
type sheriffClusterLister struct {
	kcplisters.ResourceClusterIndexer[*kcpv1alpha1.Sheriff]
}

var _ SheriffClusterLister = new(sheriffClusterLister)

// NewSheriffClusterLister returns a new SheriffClusterLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewSheriffClusterLister(indexer cache.Indexer) SheriffClusterLister {
	return &sheriffClusterLister{
		kcplisters.NewCluster[*kcpv1alpha1.Sheriff](indexer, kcpv1alpha1.Resource("sheriff")),
	}
}

// Cluster scopes the lister to one workspace, allowing users to list and get Sherifves.
func (l *sheriffClusterLister) Cluster(clusterName logicalcluster.Name) SheriffLister {
	return &sheriffLister{
		l.ResourceClusterIndexer.WithCluster(clusterName),
	}
}

// sheriffLister can list all Sherifves inside a workspace
// or scope down to a SheriffNamespaceLister for one namespace.
type sheriffLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.Sheriff]
}

var _ SheriffLister = new(sheriffLister)

// SheriffLister can list all Sherifves, or get one in particular.
// All objects returned here must be treated as read-only.
type SheriffLister interface {
	// List lists all Sherifves in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.Sheriff, err error)
	// Get retrieves the Sheriff from the indexer for a given workspace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*kcpv1alpha1.Sheriff, error)
	SheriffListerExpansion
}

// NewSheriffLister returns a new SheriffLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewSheriffLister(indexer cache.Indexer) SheriffLister {
	return &sheriffLister{
		kcplisters.New[*kcpv1alpha1.Sheriff](indexer, kcpv1alpha1.Resource("sheriff")),
	}
}

// sheriffScopedLister can list all Sherifves inside a workspace
// or scope down to a SheriffNamespaceLister.
type sheriffScopedLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.Sheriff]
}
