/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-client-gen. DO NOT EDIT.

package fake

import (
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/client-go/discovery"

	kcpfakediscovery "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/discovery/fake"
	kcptesting "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/testing"
	"github.com/kcp-dev/logicalcluster/v3"

	kcpapplyconfiguration "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/client/applyconfiguration"
	clientset "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/client/clientset/versioned"
	kcpclientset "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/client/clientset/versioned/cluster"
	kcpclientscheme "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/client/clientset/versioned/cluster/scheme"
	kcpwildwestv1alpha1 "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/client/clientset/versioned/cluster/typed/wildwest/v1alpha1"
	kcpfakewildwestv1alpha1 "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/client/clientset/versioned/cluster/typed/wildwest/v1alpha1/fake"
	wildwestv1alpha1 "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/client/clientset/versioned/typed/wildwest/v1alpha1"
)

// NewSimpleClientset returns a clientset that will respond with the provided objects.
// It's backed by a very simple object tracker that processes creates, updates and deletions as-is,
// without applying any field management, validations and/or defaults. It shouldn't be considered a replacement
// for a real clientset and is mostly useful in simple unit tests.
//
// DEPRECATED: NewClientset replaces this with support for field management, which significantly improves
// server side apply testing. NewClientset is only available when apply configurations are generated (e.g.
// via --with-applyconfig).
func NewSimpleClientset(objects ...runtime.Object) *ClusterClientset {
	o := kcptesting.NewObjectTracker(kcpclientscheme.Scheme, kcpclientscheme.Codecs.UniversalDecoder())
	o.AddAll(objects...)

	cs := &ClusterClientset{Fake: kcptesting.Fake{}, tracker: o}
	cs.discovery = &kcpfakediscovery.FakeDiscovery{Fake: &cs.Fake, ClusterPath: logicalcluster.Wildcard}
	cs.AddReactor("*", "*", kcptesting.ObjectReaction(o))
	cs.AddWatchReactor("*", kcptesting.WatchReaction(o))

	return cs
}

// ClusterClientset contains the clients for groups.
type ClusterClientset struct {
	kcptesting.Fake
	discovery *kcpfakediscovery.FakeDiscovery
	tracker   kcptesting.ObjectTracker
}

var _ kcpclientset.ClusterInterface = (*ClusterClientset)(nil)

// Discovery retrieves the DiscoveryClient
func (c *ClusterClientset) Discovery() discovery.DiscoveryInterface {
	return c.discovery
}

func (c *ClusterClientset) Tracker() kcptesting.ObjectTracker {
	return c.tracker
}

// Cluster scopes this clientset to one cluster.
func (c *ClusterClientset) Cluster(clusterPath logicalcluster.Path) clientset.Interface {
	if clusterPath == logicalcluster.Wildcard {
		panic("A specific cluster must be provided when scoping, not the wildcard.")
	}
	return &Clientset{
		Fake:        &c.Fake,
		discovery:   &kcpfakediscovery.FakeDiscovery{Fake: &c.Fake, ClusterPath: clusterPath},
		tracker:     c.tracker.Cluster(clusterPath),
		clusterPath: clusterPath,
	}
}

// WildwestV1alpha1 retrieves the WildwestV1alpha1ClusterClient
func (c *ClusterClientset) WildwestV1alpha1() kcpwildwestv1alpha1.WildwestV1alpha1ClusterInterface {
	return &kcpfakewildwestv1alpha1.WildwestV1alpha1ClusterClient{Fake: &c.Fake}
}

// Clientset implements clientset.Interface. Meant to be embedded into a
// struct to get a default implementation. This makes faking out just the method
// you want to test easier.
type Clientset struct {
	*kcptesting.Fake
	discovery   *kcpfakediscovery.FakeDiscovery
	tracker     kcptesting.ScopedObjectTracker
	clusterPath logicalcluster.Path
}

var (
	_ clientset.Interface         = &Clientset{}
	_ kcptesting.FakeScopedClient = &Clientset{}
)

func (c *Clientset) Discovery() discovery.DiscoveryInterface {
	return c.discovery
}

func (c *Clientset) Tracker() kcptesting.ScopedObjectTracker {
	return c.tracker
}

// NewClientset returns a clientset that will respond with the provided objects.
// It's backed by a very simple object tracker that processes creates, updates and deletions as-is,
// without applying any validations and/or defaults. It shouldn't be considered a replacement
// for a real clientset and is mostly useful in simple unit tests.
func NewClientset(objects ...runtime.Object) *ClusterClientset {
	o := kcptesting.NewFieldManagedObjectTracker(
		kcpclientscheme.Scheme,
		kcpclientscheme.Codecs.UniversalDecoder(),
		kcpapplyconfiguration.NewTypeConverter(kcpclientscheme.Scheme),
	)
	o.AddAll(objects...)

	cs := &ClusterClientset{Fake: kcptesting.Fake{}, tracker: o}
	cs.discovery = &kcpfakediscovery.FakeDiscovery{Fake: &cs.Fake, ClusterPath: logicalcluster.Wildcard}
	cs.AddReactor("*", "*", kcptesting.ObjectReaction(o))
	cs.AddWatchReactor("*", kcptesting.WatchReaction(o))

	return cs
}

// WildwestV1alpha1 retrieves the WildwestV1alpha1Client
func (c *Clientset) WildwestV1alpha1() wildwestv1alpha1.WildwestV1alpha1Interface {
	return &kcpfakewildwestv1alpha1.WildwestV1alpha1Client{Fake: c.Fake, ClusterPath: c.clusterPath}
}
