/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-informer-gen. DO NOT EDIT.

package v1alpha1

import (
	kcpinternalinterfaces "github.com/kcp-dev/kcp/sdk/client/informers/externalversions/internalinterfaces"
)

type ClusterInterface interface {
	// LogicalClusters returns a LogicalClusterClusterInformer.
	LogicalClusters() LogicalClusterClusterInformer
	// Shards returns a ShardClusterInformer.
	Shards() ShardClusterInformer
}

type version struct {
	factory          kcpinternalinterfaces.SharedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// New returns a new Interface.
func New(f kcpinternalinterfaces.SharedInformerFactory, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) ClusterInterface {
	return &version{factory: f, tweakListOptions: tweakListOptions}
}

// LogicalClusters returns a LogicalClusterClusterInformer.
func (v *version) LogicalClusters() LogicalClusterClusterInformer {
	return &logicalClusterClusterInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

// Shards returns a ShardClusterInformer.
func (v *version) Shards() ShardClusterInformer {
	return &shardClusterInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

type Interface interface {
	// LogicalClusters returns a LogicalClusterInformer.
	LogicalClusters() LogicalClusterInformer
	// Shards returns a ShardInformer.
	Shards() ShardInformer
}

type scopedVersion struct {
	factory          kcpinternalinterfaces.SharedScopedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
	namespace        string
}

// New returns a new Interface.
func NewScoped(f kcpinternalinterfaces.SharedScopedInformerFactory, namespace string, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) Interface {
	return &scopedVersion{factory: f, tweakListOptions: tweakListOptions}
}

// LogicalClusters returns a LogicalClusterInformer.
func (v *scopedVersion) LogicalClusters() LogicalClusterInformer {
	return &logicalClusterScopedInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

// Shards returns a ShardInformer.
func (v *scopedVersion) Shards() ShardInformer {
	return &shardScopedInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}
