/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-informer-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"

	kcpcache "github.com/kcp-dev/apimachinery/v2/pkg/cache"
	kcpinformers "github.com/kcp-dev/apimachinery/v2/third_party/informers"
	logicalcluster "github.com/kcp-dev/logicalcluster/v3"

	kcpcachev1alpha1 "github.com/kcp-dev/kcp/sdk/apis/cache/v1alpha1"
	kcpversioned "github.com/kcp-dev/kcp/sdk/client/clientset/versioned"
	kcpcluster "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster"
	kcpinternalinterfaces "github.com/kcp-dev/kcp/sdk/client/informers/externalversions/internalinterfaces"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/listers/cache/v1alpha1"
)

// CachedResourceClusterInformer provides access to a shared informer and lister for
// CachedResources.
type CachedResourceClusterInformer interface {
	Cluster(logicalcluster.Name) CachedResourceInformer
	ClusterWithContext(context.Context, logicalcluster.Name) CachedResourceInformer
	Informer() kcpcache.ScopeableSharedIndexInformer
	Lister() kcpv1alpha1.CachedResourceClusterLister
}

type cachedResourceClusterInformer struct {
	factory          kcpinternalinterfaces.SharedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewCachedResourceClusterInformer constructs a new informer for CachedResource type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewCachedResourceClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredCachedResourceClusterInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredCachedResourceClusterInformer constructs a new informer for CachedResource type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredCachedResourceClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) kcpcache.ScopeableSharedIndexInformer {
	return kcpinformers.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.CacheV1alpha1().CachedResources().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.CacheV1alpha1().CachedResources().Watch(context.Background(), options)
			},
		},
		&kcpcachev1alpha1.CachedResource{},
		resyncPeriod,
		indexers,
	)
}

func (i *cachedResourceClusterInformer) defaultInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredCachedResourceClusterInformer(client, resyncPeriod, cache.Indexers{
		kcpcache.ClusterIndexName:             kcpcache.ClusterIndexFunc,
		kcpcache.ClusterAndNamespaceIndexName: kcpcache.ClusterAndNamespaceIndexFunc,
	}, i.tweakListOptions)
}

func (i *cachedResourceClusterInformer) Informer() kcpcache.ScopeableSharedIndexInformer {
	return i.factory.InformerFor(&kcpcachev1alpha1.CachedResource{}, i.defaultInformer)
}

func (i *cachedResourceClusterInformer) Lister() kcpv1alpha1.CachedResourceClusterLister {
	return kcpv1alpha1.NewCachedResourceClusterLister(i.Informer().GetIndexer())
}

func (i *cachedResourceClusterInformer) Cluster(clusterName logicalcluster.Name) CachedResourceInformer {
	return &cachedResourceInformer{
		informer: i.Informer().Cluster(clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

func (i *cachedResourceClusterInformer) ClusterWithContext(ctx context.Context, clusterName logicalcluster.Name) CachedResourceInformer {
	return &cachedResourceInformer{
		informer: i.Informer().ClusterWithContext(ctx, clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

type cachedResourceInformer struct {
	informer cache.SharedIndexInformer
	lister   kcpv1alpha1.CachedResourceLister
}

func (i *cachedResourceInformer) Informer() cache.SharedIndexInformer {
	return i.informer
}

func (i *cachedResourceInformer) Lister() kcpv1alpha1.CachedResourceLister {
	return i.lister
}

// CachedResourceInformer provides access to a shared informer and lister for
// CachedResources.
type CachedResourceInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() kcpv1alpha1.CachedResourceLister
}

type cachedResourceScopedInformer struct {
	factory          kcpinternalinterfaces.SharedScopedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewCachedResourceInformer constructs a new informer for CachedResource type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewCachedResourceInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredCachedResourceInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredCachedResourceInformer constructs a new informer for CachedResource type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredCachedResourceInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.CacheV1alpha1().CachedResources().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.CacheV1alpha1().CachedResources().Watch(context.Background(), options)
			},
		},
		&kcpcachev1alpha1.CachedResource{},
		resyncPeriod,
		indexers,
	)
}

func (i *cachedResourceScopedInformer) Informer() cache.SharedIndexInformer {
	return i.factory.InformerFor(&kcpcachev1alpha1.CachedResource{}, i.defaultInformer)
}

func (i *cachedResourceScopedInformer) Lister() kcpv1alpha1.CachedResourceLister {
	return kcpv1alpha1.NewCachedResourceLister(i.Informer().GetIndexer())
}

func (i *cachedResourceScopedInformer) defaultInformer(client kcpversioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredCachedResourceInformer(client, resyncPeriod, cache.Indexers{}, i.tweakListOptions)
}
