/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-informer-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"

	kcpcache "github.com/kcp-dev/apimachinery/v2/pkg/cache"
	kcpinformers "github.com/kcp-dev/apimachinery/v2/third_party/informers"
	logicalcluster "github.com/kcp-dev/logicalcluster/v3"

	kcpapisv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/apis/v1alpha1"
	kcpversioned "github.com/kcp-dev/kcp/sdk/client/clientset/versioned"
	kcpcluster "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster"
	kcpinternalinterfaces "github.com/kcp-dev/kcp/sdk/client/informers/externalversions/internalinterfaces"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/listers/apis/v1alpha1"
)

// APIBindingClusterInformer provides access to a shared informer and lister for
// APIBindings.
type APIBindingClusterInformer interface {
	Cluster(logicalcluster.Name) APIBindingInformer
	ClusterWithContext(context.Context, logicalcluster.Name) APIBindingInformer
	Informer() kcpcache.ScopeableSharedIndexInformer
	Lister() kcpv1alpha1.APIBindingClusterLister
}

type aPIBindingClusterInformer struct {
	factory          kcpinternalinterfaces.SharedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewAPIBindingClusterInformer constructs a new informer for APIBinding type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewAPIBindingClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredAPIBindingClusterInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredAPIBindingClusterInformer constructs a new informer for APIBinding type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredAPIBindingClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) kcpcache.ScopeableSharedIndexInformer {
	return kcpinformers.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ApisV1alpha1().APIBindings().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ApisV1alpha1().APIBindings().Watch(context.Background(), options)
			},
		},
		&kcpapisv1alpha1.APIBinding{},
		resyncPeriod,
		indexers,
	)
}

func (i *aPIBindingClusterInformer) defaultInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredAPIBindingClusterInformer(client, resyncPeriod, cache.Indexers{
		kcpcache.ClusterIndexName:             kcpcache.ClusterIndexFunc,
		kcpcache.ClusterAndNamespaceIndexName: kcpcache.ClusterAndNamespaceIndexFunc,
	}, i.tweakListOptions)
}

func (i *aPIBindingClusterInformer) Informer() kcpcache.ScopeableSharedIndexInformer {
	return i.factory.InformerFor(&kcpapisv1alpha1.APIBinding{}, i.defaultInformer)
}

func (i *aPIBindingClusterInformer) Lister() kcpv1alpha1.APIBindingClusterLister {
	return kcpv1alpha1.NewAPIBindingClusterLister(i.Informer().GetIndexer())
}

func (i *aPIBindingClusterInformer) Cluster(clusterName logicalcluster.Name) APIBindingInformer {
	return &aPIBindingInformer{
		informer: i.Informer().Cluster(clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

func (i *aPIBindingClusterInformer) ClusterWithContext(ctx context.Context, clusterName logicalcluster.Name) APIBindingInformer {
	return &aPIBindingInformer{
		informer: i.Informer().ClusterWithContext(ctx, clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

type aPIBindingInformer struct {
	informer cache.SharedIndexInformer
	lister   kcpv1alpha1.APIBindingLister
}

func (i *aPIBindingInformer) Informer() cache.SharedIndexInformer {
	return i.informer
}

func (i *aPIBindingInformer) Lister() kcpv1alpha1.APIBindingLister {
	return i.lister
}

// APIBindingInformer provides access to a shared informer and lister for
// APIBindings.
type APIBindingInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() kcpv1alpha1.APIBindingLister
}

type aPIBindingScopedInformer struct {
	factory          kcpinternalinterfaces.SharedScopedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewAPIBindingInformer constructs a new informer for APIBinding type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewAPIBindingInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredAPIBindingInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredAPIBindingInformer constructs a new informer for APIBinding type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredAPIBindingInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ApisV1alpha1().APIBindings().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.ApisV1alpha1().APIBindings().Watch(context.Background(), options)
			},
		},
		&kcpapisv1alpha1.APIBinding{},
		resyncPeriod,
		indexers,
	)
}

func (i *aPIBindingScopedInformer) Informer() cache.SharedIndexInformer {
	return i.factory.InformerFor(&kcpapisv1alpha1.APIBinding{}, i.defaultInformer)
}

func (i *aPIBindingScopedInformer) Lister() kcpv1alpha1.APIBindingLister {
	return kcpv1alpha1.NewAPIBindingLister(i.Informer().GetIndexer())
}

func (i *aPIBindingScopedInformer) defaultInformer(client kcpversioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredAPIBindingInformer(client, resyncPeriod, cache.Indexers{}, i.tweakListOptions)
}
