/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha2

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"

	apisv1alpha2 "github.com/kcp-dev/kcp/sdk/apis/apis/v1alpha2"
	applyconfigurationapisv1alpha2 "github.com/kcp-dev/kcp/sdk/client/applyconfiguration/apis/v1alpha2"
	scheme "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/scheme"
)

// APIExportsGetter has a method to return a APIExportInterface.
// A group's client should implement this interface.
type APIExportsGetter interface {
	APIExports() APIExportInterface
}

// APIExportInterface has methods to work with APIExport resources.
type APIExportInterface interface {
	Create(ctx context.Context, aPIExport *apisv1alpha2.APIExport, opts v1.CreateOptions) (*apisv1alpha2.APIExport, error)
	Update(ctx context.Context, aPIExport *apisv1alpha2.APIExport, opts v1.UpdateOptions) (*apisv1alpha2.APIExport, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, aPIExport *apisv1alpha2.APIExport, opts v1.UpdateOptions) (*apisv1alpha2.APIExport, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*apisv1alpha2.APIExport, error)
	List(ctx context.Context, opts v1.ListOptions) (*apisv1alpha2.APIExportList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *apisv1alpha2.APIExport, err error)
	Apply(ctx context.Context, aPIExport *applyconfigurationapisv1alpha2.APIExportApplyConfiguration, opts v1.ApplyOptions) (result *apisv1alpha2.APIExport, err error)
	// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
	ApplyStatus(ctx context.Context, aPIExport *applyconfigurationapisv1alpha2.APIExportApplyConfiguration, opts v1.ApplyOptions) (result *apisv1alpha2.APIExport, err error)
	APIExportExpansion
}

// aPIExports implements APIExportInterface
type aPIExports struct {
	*gentype.ClientWithListAndApply[*apisv1alpha2.APIExport, *apisv1alpha2.APIExportList, *applyconfigurationapisv1alpha2.APIExportApplyConfiguration]
}

// newAPIExports returns a APIExports
func newAPIExports(c *ApisV1alpha2Client) *aPIExports {
	return &aPIExports{
		gentype.NewClientWithListAndApply[*apisv1alpha2.APIExport, *apisv1alpha2.APIExportList, *applyconfigurationapisv1alpha2.APIExportApplyConfiguration](
			"apiexports",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *apisv1alpha2.APIExport { return &apisv1alpha2.APIExport{} },
			func() *apisv1alpha2.APIExportList { return &apisv1alpha2.APIExportList{} },
		),
	}
}
