/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	v1 "k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1"
)

// APIResourceSchemaSpecApplyConfiguration represents a declarative configuration of the APIResourceSchemaSpec type for use
// with apply.
type APIResourceSchemaSpecApplyConfiguration struct {
	Group          *string                                     `json:"group,omitempty"`
	Names          *v1.CustomResourceDefinitionNames           `json:"names,omitempty"`
	Scope          *v1.ResourceScope                           `json:"scope,omitempty"`
	Versions       []APIResourceVersionApplyConfiguration      `json:"versions,omitempty"`
	NameValidation *string                                     `json:"nameValidation,omitempty"`
	Conversion     *CustomResourceConversionApplyConfiguration `json:"conversion,omitempty"`
}

// APIResourceSchemaSpecApplyConfiguration constructs a declarative configuration of the APIResourceSchemaSpec type for use with
// apply.
func APIResourceSchemaSpec() *APIResourceSchemaSpecApplyConfiguration {
	return &APIResourceSchemaSpecApplyConfiguration{}
}

// WithGroup sets the Group field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Group field is set to the value of the last call.
func (b *APIResourceSchemaSpecApplyConfiguration) WithGroup(value string) *APIResourceSchemaSpecApplyConfiguration {
	b.Group = &value
	return b
}

// WithNames sets the Names field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Names field is set to the value of the last call.
func (b *APIResourceSchemaSpecApplyConfiguration) WithNames(value v1.CustomResourceDefinitionNames) *APIResourceSchemaSpecApplyConfiguration {
	b.Names = &value
	return b
}

// WithScope sets the Scope field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Scope field is set to the value of the last call.
func (b *APIResourceSchemaSpecApplyConfiguration) WithScope(value v1.ResourceScope) *APIResourceSchemaSpecApplyConfiguration {
	b.Scope = &value
	return b
}

// WithVersions adds the given value to the Versions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Versions field.
func (b *APIResourceSchemaSpecApplyConfiguration) WithVersions(values ...*APIResourceVersionApplyConfiguration) *APIResourceSchemaSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithVersions")
		}
		b.Versions = append(b.Versions, *values[i])
	}
	return b
}

// WithNameValidation sets the NameValidation field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NameValidation field is set to the value of the last call.
func (b *APIResourceSchemaSpecApplyConfiguration) WithNameValidation(value string) *APIResourceSchemaSpecApplyConfiguration {
	b.NameValidation = &value
	return b
}

// WithConversion sets the Conversion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Conversion field is set to the value of the last call.
func (b *APIResourceSchemaSpecApplyConfiguration) WithConversion(value *CustomResourceConversionApplyConfiguration) *APIResourceSchemaSpecApplyConfiguration {
	b.Conversion = value
	return b
}
