/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"

	kcplisters "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/listers"
	"github.com/kcp-dev/logicalcluster/v3"

	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/core/v1alpha1"
)

// LogicalClusterClusterLister helps list LogicalClusters across all workspaces,
// or scope down to a LogicalClusterLister for one workspace.
// All objects returned here must be treated as read-only.
type LogicalClusterClusterLister interface {
	// List lists all LogicalClusters in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.LogicalCluster, err error)
	// Cluster returns a lister that can list and get LogicalClusters in one workspace.
	Cluster(clusterName logicalcluster.Name) LogicalClusterLister
	LogicalClusterClusterListerExpansion
}

// logicalClusterClusterLister implements the LogicalClusterClusterLister interface.
type logicalClusterClusterLister struct {
	kcplisters.ResourceClusterIndexer[*kcpv1alpha1.LogicalCluster]
}

var _ LogicalClusterClusterLister = new(logicalClusterClusterLister)

// NewLogicalClusterClusterLister returns a new LogicalClusterClusterLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewLogicalClusterClusterLister(indexer cache.Indexer) LogicalClusterClusterLister {
	return &logicalClusterClusterLister{
		kcplisters.NewCluster[*kcpv1alpha1.LogicalCluster](indexer, kcpv1alpha1.Resource("logicalcluster")),
	}
}

// Cluster scopes the lister to one workspace, allowing users to list and get LogicalClusters.
func (l *logicalClusterClusterLister) Cluster(clusterName logicalcluster.Name) LogicalClusterLister {
	return &logicalClusterLister{
		l.ResourceClusterIndexer.WithCluster(clusterName),
	}
}

// logicalClusterLister can list all LogicalClusters inside a workspace
// or scope down to a LogicalClusterNamespaceLister for one namespace.
type logicalClusterLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.LogicalCluster]
}

var _ LogicalClusterLister = new(logicalClusterLister)

// LogicalClusterLister can list all LogicalClusters, or get one in particular.
// All objects returned here must be treated as read-only.
type LogicalClusterLister interface {
	// List lists all LogicalClusters in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.LogicalCluster, err error)
	// Get retrieves the LogicalCluster from the indexer for a given workspace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*kcpv1alpha1.LogicalCluster, error)
	LogicalClusterListerExpansion
}

// NewLogicalClusterLister returns a new LogicalClusterLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewLogicalClusterLister(indexer cache.Indexer) LogicalClusterLister {
	return &logicalClusterLister{
		kcplisters.New[*kcpv1alpha1.LogicalCluster](indexer, kcpv1alpha1.Resource("logicalcluster")),
	}
}

// logicalClusterScopedLister can list all LogicalClusters inside a workspace
// or scope down to a LogicalClusterNamespaceLister.
type logicalClusterScopedLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.LogicalCluster]
}
