/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"

	kcplisters "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/listers"
	"github.com/kcp-dev/logicalcluster/v3"

	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/cache/v1alpha1"
)

// CachedResourceEndpointSliceClusterLister helps list CachedResourceEndpointSlices across all workspaces,
// or scope down to a CachedResourceEndpointSliceLister for one workspace.
// All objects returned here must be treated as read-only.
type CachedResourceEndpointSliceClusterLister interface {
	// List lists all CachedResourceEndpointSlices in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.CachedResourceEndpointSlice, err error)
	// Cluster returns a lister that can list and get CachedResourceEndpointSlices in one workspace.
	Cluster(clusterName logicalcluster.Name) CachedResourceEndpointSliceLister
	CachedResourceEndpointSliceClusterListerExpansion
}

// cachedResourceEndpointSliceClusterLister implements the CachedResourceEndpointSliceClusterLister interface.
type cachedResourceEndpointSliceClusterLister struct {
	kcplisters.ResourceClusterIndexer[*kcpv1alpha1.CachedResourceEndpointSlice]
}

var _ CachedResourceEndpointSliceClusterLister = new(cachedResourceEndpointSliceClusterLister)

// NewCachedResourceEndpointSliceClusterLister returns a new CachedResourceEndpointSliceClusterLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewCachedResourceEndpointSliceClusterLister(indexer cache.Indexer) CachedResourceEndpointSliceClusterLister {
	return &cachedResourceEndpointSliceClusterLister{
		kcplisters.NewCluster[*kcpv1alpha1.CachedResourceEndpointSlice](indexer, kcpv1alpha1.Resource("cachedresourceendpointslice")),
	}
}

// Cluster scopes the lister to one workspace, allowing users to list and get CachedResourceEndpointSlices.
func (l *cachedResourceEndpointSliceClusterLister) Cluster(clusterName logicalcluster.Name) CachedResourceEndpointSliceLister {
	return &cachedResourceEndpointSliceLister{
		l.ResourceClusterIndexer.WithCluster(clusterName),
	}
}

// cachedResourceEndpointSliceLister can list all CachedResourceEndpointSlices inside a workspace
// or scope down to a CachedResourceEndpointSliceNamespaceLister for one namespace.
type cachedResourceEndpointSliceLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.CachedResourceEndpointSlice]
}

var _ CachedResourceEndpointSliceLister = new(cachedResourceEndpointSliceLister)

// CachedResourceEndpointSliceLister can list all CachedResourceEndpointSlices, or get one in particular.
// All objects returned here must be treated as read-only.
type CachedResourceEndpointSliceLister interface {
	// List lists all CachedResourceEndpointSlices in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.CachedResourceEndpointSlice, err error)
	// Get retrieves the CachedResourceEndpointSlice from the indexer for a given workspace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*kcpv1alpha1.CachedResourceEndpointSlice, error)
	CachedResourceEndpointSliceListerExpansion
}

// NewCachedResourceEndpointSliceLister returns a new CachedResourceEndpointSliceLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewCachedResourceEndpointSliceLister(indexer cache.Indexer) CachedResourceEndpointSliceLister {
	return &cachedResourceEndpointSliceLister{
		kcplisters.New[*kcpv1alpha1.CachedResourceEndpointSlice](indexer, kcpv1alpha1.Resource("cachedresourceendpointslice")),
	}
}

// cachedResourceEndpointSliceScopedLister can list all CachedResourceEndpointSlices inside a workspace
// or scope down to a CachedResourceEndpointSliceNamespaceLister.
type cachedResourceEndpointSliceScopedLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.CachedResourceEndpointSlice]
}
