/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"

	kcplisters "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/listers"
	"github.com/kcp-dev/logicalcluster/v3"

	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/apis/v1alpha1"
)

// APIBindingClusterLister helps list APIBindings across all workspaces,
// or scope down to a APIBindingLister for one workspace.
// All objects returned here must be treated as read-only.
type APIBindingClusterLister interface {
	// List lists all APIBindings in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.APIBinding, err error)
	// Cluster returns a lister that can list and get APIBindings in one workspace.
	Cluster(clusterName logicalcluster.Name) APIBindingLister
	APIBindingClusterListerExpansion
}

// aPIBindingClusterLister implements the APIBindingClusterLister interface.
type aPIBindingClusterLister struct {
	kcplisters.ResourceClusterIndexer[*kcpv1alpha1.APIBinding]
}

var _ APIBindingClusterLister = new(aPIBindingClusterLister)

// NewAPIBindingClusterLister returns a new APIBindingClusterLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewAPIBindingClusterLister(indexer cache.Indexer) APIBindingClusterLister {
	return &aPIBindingClusterLister{
		kcplisters.NewCluster[*kcpv1alpha1.APIBinding](indexer, kcpv1alpha1.Resource("apibinding")),
	}
}

// Cluster scopes the lister to one workspace, allowing users to list and get APIBindings.
func (l *aPIBindingClusterLister) Cluster(clusterName logicalcluster.Name) APIBindingLister {
	return &aPIBindingLister{
		l.ResourceClusterIndexer.WithCluster(clusterName),
	}
}

// aPIBindingLister can list all APIBindings inside a workspace
// or scope down to a APIBindingNamespaceLister for one namespace.
type aPIBindingLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.APIBinding]
}

var _ APIBindingLister = new(aPIBindingLister)

// APIBindingLister can list all APIBindings, or get one in particular.
// All objects returned here must be treated as read-only.
type APIBindingLister interface {
	// List lists all APIBindings in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.APIBinding, err error)
	// Get retrieves the APIBinding from the indexer for a given workspace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*kcpv1alpha1.APIBinding, error)
	APIBindingListerExpansion
}

// NewAPIBindingLister returns a new APIBindingLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewAPIBindingLister(indexer cache.Indexer) APIBindingLister {
	return &aPIBindingLister{
		kcplisters.New[*kcpv1alpha1.APIBinding](indexer, kcpv1alpha1.Resource("apibinding")),
	}
}

// aPIBindingScopedLister can list all APIBindings inside a workspace
// or scope down to a APIBindingNamespaceLister.
type aPIBindingScopedLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.APIBinding]
}
