/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-informer-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"

	kcpcache "github.com/kcp-dev/apimachinery/v2/pkg/cache"
	kcpinformers "github.com/kcp-dev/apimachinery/v2/third_party/informers"
	logicalcluster "github.com/kcp-dev/logicalcluster/v3"

	kcptopologyv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/topology/v1alpha1"
	kcpversioned "github.com/kcp-dev/kcp/sdk/client/clientset/versioned"
	kcpcluster "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster"
	kcpinternalinterfaces "github.com/kcp-dev/kcp/sdk/client/informers/externalversions/internalinterfaces"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/listers/topology/v1alpha1"
)

// PartitionSetClusterInformer provides access to a shared informer and lister for
// PartitionSets.
type PartitionSetClusterInformer interface {
	Cluster(logicalcluster.Name) PartitionSetInformer
	ClusterWithContext(context.Context, logicalcluster.Name) PartitionSetInformer
	Informer() kcpcache.ScopeableSharedIndexInformer
	Lister() kcpv1alpha1.PartitionSetClusterLister
}

type partitionSetClusterInformer struct {
	factory          kcpinternalinterfaces.SharedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewPartitionSetClusterInformer constructs a new informer for PartitionSet type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewPartitionSetClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredPartitionSetClusterInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredPartitionSetClusterInformer constructs a new informer for PartitionSet type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredPartitionSetClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) kcpcache.ScopeableSharedIndexInformer {
	return kcpinformers.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.TopologyV1alpha1().PartitionSets().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.TopologyV1alpha1().PartitionSets().Watch(context.Background(), options)
			},
		},
		&kcptopologyv1alpha1.PartitionSet{},
		resyncPeriod,
		indexers,
	)
}

func (i *partitionSetClusterInformer) defaultInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredPartitionSetClusterInformer(client, resyncPeriod, cache.Indexers{
		kcpcache.ClusterIndexName:             kcpcache.ClusterIndexFunc,
		kcpcache.ClusterAndNamespaceIndexName: kcpcache.ClusterAndNamespaceIndexFunc,
	}, i.tweakListOptions)
}

func (i *partitionSetClusterInformer) Informer() kcpcache.ScopeableSharedIndexInformer {
	return i.factory.InformerFor(&kcptopologyv1alpha1.PartitionSet{}, i.defaultInformer)
}

func (i *partitionSetClusterInformer) Lister() kcpv1alpha1.PartitionSetClusterLister {
	return kcpv1alpha1.NewPartitionSetClusterLister(i.Informer().GetIndexer())
}

func (i *partitionSetClusterInformer) Cluster(clusterName logicalcluster.Name) PartitionSetInformer {
	return &partitionSetInformer{
		informer: i.Informer().Cluster(clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

func (i *partitionSetClusterInformer) ClusterWithContext(ctx context.Context, clusterName logicalcluster.Name) PartitionSetInformer {
	return &partitionSetInformer{
		informer: i.Informer().ClusterWithContext(ctx, clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

type partitionSetInformer struct {
	informer cache.SharedIndexInformer
	lister   kcpv1alpha1.PartitionSetLister
}

func (i *partitionSetInformer) Informer() cache.SharedIndexInformer {
	return i.informer
}

func (i *partitionSetInformer) Lister() kcpv1alpha1.PartitionSetLister {
	return i.lister
}

// PartitionSetInformer provides access to a shared informer and lister for
// PartitionSets.
type PartitionSetInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() kcpv1alpha1.PartitionSetLister
}

type partitionSetScopedInformer struct {
	factory          kcpinternalinterfaces.SharedScopedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewPartitionSetInformer constructs a new informer for PartitionSet type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewPartitionSetInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredPartitionSetInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredPartitionSetInformer constructs a new informer for PartitionSet type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredPartitionSetInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.TopologyV1alpha1().PartitionSets().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.TopologyV1alpha1().PartitionSets().Watch(context.Background(), options)
			},
		},
		&kcptopologyv1alpha1.PartitionSet{},
		resyncPeriod,
		indexers,
	)
}

func (i *partitionSetScopedInformer) Informer() cache.SharedIndexInformer {
	return i.factory.InformerFor(&kcptopologyv1alpha1.PartitionSet{}, i.defaultInformer)
}

func (i *partitionSetScopedInformer) Lister() kcpv1alpha1.PartitionSetLister {
	return kcpv1alpha1.NewPartitionSetLister(i.Informer().GetIndexer())
}

func (i *partitionSetScopedInformer) defaultInformer(client kcpversioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredPartitionSetInformer(client, resyncPeriod, cache.Indexers{}, i.tweakListOptions)
}
