/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-informer-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"

	kcpcache "github.com/kcp-dev/apimachinery/v2/pkg/cache"
	kcpinformers "github.com/kcp-dev/apimachinery/v2/third_party/informers"
	logicalcluster "github.com/kcp-dev/logicalcluster/v3"

	kcptenancyv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/tenancy/v1alpha1"
	kcpversioned "github.com/kcp-dev/kcp/sdk/client/clientset/versioned"
	kcpcluster "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster"
	kcpinternalinterfaces "github.com/kcp-dev/kcp/sdk/client/informers/externalversions/internalinterfaces"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/listers/tenancy/v1alpha1"
)

// WorkspaceTypeClusterInformer provides access to a shared informer and lister for
// WorkspaceTypes.
type WorkspaceTypeClusterInformer interface {
	Cluster(logicalcluster.Name) WorkspaceTypeInformer
	ClusterWithContext(context.Context, logicalcluster.Name) WorkspaceTypeInformer
	Informer() kcpcache.ScopeableSharedIndexInformer
	Lister() kcpv1alpha1.WorkspaceTypeClusterLister
}

type workspaceTypeClusterInformer struct {
	factory          kcpinternalinterfaces.SharedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewWorkspaceTypeClusterInformer constructs a new informer for WorkspaceType type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewWorkspaceTypeClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredWorkspaceTypeClusterInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredWorkspaceTypeClusterInformer constructs a new informer for WorkspaceType type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredWorkspaceTypeClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) kcpcache.ScopeableSharedIndexInformer {
	return kcpinformers.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.TenancyV1alpha1().WorkspaceTypes().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.TenancyV1alpha1().WorkspaceTypes().Watch(context.Background(), options)
			},
		},
		&kcptenancyv1alpha1.WorkspaceType{},
		resyncPeriod,
		indexers,
	)
}

func (i *workspaceTypeClusterInformer) defaultInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredWorkspaceTypeClusterInformer(client, resyncPeriod, cache.Indexers{
		kcpcache.ClusterIndexName:             kcpcache.ClusterIndexFunc,
		kcpcache.ClusterAndNamespaceIndexName: kcpcache.ClusterAndNamespaceIndexFunc,
	}, i.tweakListOptions)
}

func (i *workspaceTypeClusterInformer) Informer() kcpcache.ScopeableSharedIndexInformer {
	return i.factory.InformerFor(&kcptenancyv1alpha1.WorkspaceType{}, i.defaultInformer)
}

func (i *workspaceTypeClusterInformer) Lister() kcpv1alpha1.WorkspaceTypeClusterLister {
	return kcpv1alpha1.NewWorkspaceTypeClusterLister(i.Informer().GetIndexer())
}

func (i *workspaceTypeClusterInformer) Cluster(clusterName logicalcluster.Name) WorkspaceTypeInformer {
	return &workspaceTypeInformer{
		informer: i.Informer().Cluster(clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

func (i *workspaceTypeClusterInformer) ClusterWithContext(ctx context.Context, clusterName logicalcluster.Name) WorkspaceTypeInformer {
	return &workspaceTypeInformer{
		informer: i.Informer().ClusterWithContext(ctx, clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

type workspaceTypeInformer struct {
	informer cache.SharedIndexInformer
	lister   kcpv1alpha1.WorkspaceTypeLister
}

func (i *workspaceTypeInformer) Informer() cache.SharedIndexInformer {
	return i.informer
}

func (i *workspaceTypeInformer) Lister() kcpv1alpha1.WorkspaceTypeLister {
	return i.lister
}

// WorkspaceTypeInformer provides access to a shared informer and lister for
// WorkspaceTypes.
type WorkspaceTypeInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() kcpv1alpha1.WorkspaceTypeLister
}

type workspaceTypeScopedInformer struct {
	factory          kcpinternalinterfaces.SharedScopedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewWorkspaceTypeInformer constructs a new informer for WorkspaceType type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewWorkspaceTypeInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredWorkspaceTypeInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredWorkspaceTypeInformer constructs a new informer for WorkspaceType type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredWorkspaceTypeInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.TenancyV1alpha1().WorkspaceTypes().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.TenancyV1alpha1().WorkspaceTypes().Watch(context.Background(), options)
			},
		},
		&kcptenancyv1alpha1.WorkspaceType{},
		resyncPeriod,
		indexers,
	)
}

func (i *workspaceTypeScopedInformer) Informer() cache.SharedIndexInformer {
	return i.factory.InformerFor(&kcptenancyv1alpha1.WorkspaceType{}, i.defaultInformer)
}

func (i *workspaceTypeScopedInformer) Lister() kcpv1alpha1.WorkspaceTypeLister {
	return kcpv1alpha1.NewWorkspaceTypeLister(i.Informer().GetIndexer())
}

func (i *workspaceTypeScopedInformer) defaultInformer(client kcpversioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredWorkspaceTypeInformer(client, resyncPeriod, cache.Indexers{}, i.tweakListOptions)
}
