/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-informer-gen. DO NOT EDIT.

package v1alpha2

import (
	kcpinternalinterfaces "github.com/kcp-dev/kcp/sdk/client/informers/externalversions/internalinterfaces"
)

type ClusterInterface interface {
	// APIBindings returns a APIBindingClusterInformer.
	APIBindings() APIBindingClusterInformer
	// APIExports returns a APIExportClusterInformer.
	APIExports() APIExportClusterInformer
}

type version struct {
	factory          kcpinternalinterfaces.SharedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// New returns a new Interface.
func New(f kcpinternalinterfaces.SharedInformerFactory, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) ClusterInterface {
	return &version{factory: f, tweakListOptions: tweakListOptions}
}

// APIBindings returns a APIBindingClusterInformer.
func (v *version) APIBindings() APIBindingClusterInformer {
	return &aPIBindingClusterInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

// APIExports returns a APIExportClusterInformer.
func (v *version) APIExports() APIExportClusterInformer {
	return &aPIExportClusterInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

type Interface interface {
	// APIBindings returns a APIBindingInformer.
	APIBindings() APIBindingInformer
	// APIExports returns a APIExportInformer.
	APIExports() APIExportInformer
}

type scopedVersion struct {
	factory          kcpinternalinterfaces.SharedScopedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
	namespace        string
}

// New returns a new Interface.
func NewScoped(f kcpinternalinterfaces.SharedScopedInformerFactory, namespace string, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) Interface {
	return &scopedVersion{factory: f, tweakListOptions: tweakListOptions}
}

// APIBindings returns a APIBindingInformer.
func (v *scopedVersion) APIBindings() APIBindingInformer {
	return &aPIBindingScopedInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

// APIExports returns a APIExportInformer.
func (v *scopedVersion) APIExports() APIExportInformer {
	return &aPIExportScopedInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}
