/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-client-gen. DO NOT EDIT.

package fake

import (
	kcpgentype "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/gentype"
	kcptesting "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/testing"
	"github.com/kcp-dev/logicalcluster/v3"

	cachev1alpha1 "github.com/kcp-dev/kcp/sdk/apis/cache/v1alpha1"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/applyconfiguration/cache/v1alpha1"
	typedkcpcachev1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/cache/v1alpha1"
	typedcachev1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/typed/cache/v1alpha1"
)

// cachedResourceEndpointSliceClusterClient implements CachedResourceEndpointSliceClusterInterface
type cachedResourceEndpointSliceClusterClient struct {
	*kcpgentype.FakeClusterClientWithList[*cachev1alpha1.CachedResourceEndpointSlice, *cachev1alpha1.CachedResourceEndpointSliceList]
	Fake *kcptesting.Fake
}

func newFakeCachedResourceEndpointSliceClusterClient(fake *CacheV1alpha1ClusterClient) typedkcpcachev1alpha1.CachedResourceEndpointSliceClusterInterface {
	return &cachedResourceEndpointSliceClusterClient{
		kcpgentype.NewFakeClusterClientWithList[*cachev1alpha1.CachedResourceEndpointSlice, *cachev1alpha1.CachedResourceEndpointSliceList](
			fake.Fake,
			cachev1alpha1.SchemeGroupVersion.WithResource("cachedresourceendpointslices"),
			cachev1alpha1.SchemeGroupVersion.WithKind("CachedResourceEndpointSlice"),
			func() *cachev1alpha1.CachedResourceEndpointSlice { return &cachev1alpha1.CachedResourceEndpointSlice{} },
			func() *cachev1alpha1.CachedResourceEndpointSliceList {
				return &cachev1alpha1.CachedResourceEndpointSliceList{}
			},
			func(dst, src *cachev1alpha1.CachedResourceEndpointSliceList) { dst.ListMeta = src.ListMeta },
			func(list *cachev1alpha1.CachedResourceEndpointSliceList) []*cachev1alpha1.CachedResourceEndpointSlice {
				return kcpgentype.ToPointerSlice(list.Items)
			},
			func(list *cachev1alpha1.CachedResourceEndpointSliceList, items []*cachev1alpha1.CachedResourceEndpointSlice) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake.Fake,
	}
}

func (c *cachedResourceEndpointSliceClusterClient) Cluster(cluster logicalcluster.Path) typedcachev1alpha1.CachedResourceEndpointSliceInterface {
	return newFakeCachedResourceEndpointSliceClient(c.Fake, cluster)
}

// cachedResourceEndpointSliceScopedClient implements CachedResourceEndpointSliceInterface
type cachedResourceEndpointSliceScopedClient struct {
	*kcpgentype.FakeClientWithListAndApply[*cachev1alpha1.CachedResourceEndpointSlice, *cachev1alpha1.CachedResourceEndpointSliceList, *kcpv1alpha1.CachedResourceEndpointSliceApplyConfiguration]
	Fake        *kcptesting.Fake
	ClusterPath logicalcluster.Path
}

func newFakeCachedResourceEndpointSliceClient(fake *kcptesting.Fake, clusterPath logicalcluster.Path) typedcachev1alpha1.CachedResourceEndpointSliceInterface {
	return &cachedResourceEndpointSliceScopedClient{
		kcpgentype.NewFakeClientWithListAndApply[*cachev1alpha1.CachedResourceEndpointSlice, *cachev1alpha1.CachedResourceEndpointSliceList, *kcpv1alpha1.CachedResourceEndpointSliceApplyConfiguration](
			fake,
			clusterPath,
			"",
			cachev1alpha1.SchemeGroupVersion.WithResource("cachedresourceendpointslices"),
			cachev1alpha1.SchemeGroupVersion.WithKind("CachedResourceEndpointSlice"),
			func() *cachev1alpha1.CachedResourceEndpointSlice { return &cachev1alpha1.CachedResourceEndpointSlice{} },
			func() *cachev1alpha1.CachedResourceEndpointSliceList {
				return &cachev1alpha1.CachedResourceEndpointSliceList{}
			},
			func(dst, src *cachev1alpha1.CachedResourceEndpointSliceList) { dst.ListMeta = src.ListMeta },
			func(list *cachev1alpha1.CachedResourceEndpointSliceList) []*cachev1alpha1.CachedResourceEndpointSlice {
				return kcpgentype.ToPointerSlice(list.Items)
			},
			func(list *cachev1alpha1.CachedResourceEndpointSliceList, items []*cachev1alpha1.CachedResourceEndpointSlice) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake,
		clusterPath,
	}
}
