/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-client-gen. DO NOT EDIT.

package fake

import (
	kcpgentype "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/gentype"
	kcptesting "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/testing"
	"github.com/kcp-dev/logicalcluster/v3"

	cachev1alpha1 "github.com/kcp-dev/kcp/sdk/apis/cache/v1alpha1"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/applyconfiguration/cache/v1alpha1"
	typedkcpcachev1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/cache/v1alpha1"
	typedcachev1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/typed/cache/v1alpha1"
)

// cachedResourceClusterClient implements CachedResourceClusterInterface
type cachedResourceClusterClient struct {
	*kcpgentype.FakeClusterClientWithList[*cachev1alpha1.CachedResource, *cachev1alpha1.CachedResourceList]
	Fake *kcptesting.Fake
}

func newFakeCachedResourceClusterClient(fake *CacheV1alpha1ClusterClient) typedkcpcachev1alpha1.CachedResourceClusterInterface {
	return &cachedResourceClusterClient{
		kcpgentype.NewFakeClusterClientWithList[*cachev1alpha1.CachedResource, *cachev1alpha1.CachedResourceList](
			fake.Fake,
			cachev1alpha1.SchemeGroupVersion.WithResource("cachedresources"),
			cachev1alpha1.SchemeGroupVersion.WithKind("CachedResource"),
			func() *cachev1alpha1.CachedResource { return &cachev1alpha1.CachedResource{} },
			func() *cachev1alpha1.CachedResourceList { return &cachev1alpha1.CachedResourceList{} },
			func(dst, src *cachev1alpha1.CachedResourceList) { dst.ListMeta = src.ListMeta },
			func(list *cachev1alpha1.CachedResourceList) []*cachev1alpha1.CachedResource {
				return kcpgentype.ToPointerSlice(list.Items)
			},
			func(list *cachev1alpha1.CachedResourceList, items []*cachev1alpha1.CachedResource) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake.Fake,
	}
}

func (c *cachedResourceClusterClient) Cluster(cluster logicalcluster.Path) typedcachev1alpha1.CachedResourceInterface {
	return newFakeCachedResourceClient(c.Fake, cluster)
}

// cachedResourceScopedClient implements CachedResourceInterface
type cachedResourceScopedClient struct {
	*kcpgentype.FakeClientWithListAndApply[*cachev1alpha1.CachedResource, *cachev1alpha1.CachedResourceList, *kcpv1alpha1.CachedResourceApplyConfiguration]
	Fake        *kcptesting.Fake
	ClusterPath logicalcluster.Path
}

func newFakeCachedResourceClient(fake *kcptesting.Fake, clusterPath logicalcluster.Path) typedcachev1alpha1.CachedResourceInterface {
	return &cachedResourceScopedClient{
		kcpgentype.NewFakeClientWithListAndApply[*cachev1alpha1.CachedResource, *cachev1alpha1.CachedResourceList, *kcpv1alpha1.CachedResourceApplyConfiguration](
			fake,
			clusterPath,
			"",
			cachev1alpha1.SchemeGroupVersion.WithResource("cachedresources"),
			cachev1alpha1.SchemeGroupVersion.WithKind("CachedResource"),
			func() *cachev1alpha1.CachedResource { return &cachev1alpha1.CachedResource{} },
			func() *cachev1alpha1.CachedResourceList { return &cachev1alpha1.CachedResourceList{} },
			func(dst, src *cachev1alpha1.CachedResourceList) { dst.ListMeta = src.ListMeta },
			func(list *cachev1alpha1.CachedResourceList) []*cachev1alpha1.CachedResource {
				return kcpgentype.ToPointerSlice(list.Items)
			},
			func(list *cachev1alpha1.CachedResourceList, items []*cachev1alpha1.CachedResource) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake,
		clusterPath,
	}
}
