/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-client-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	watch "k8s.io/apimachinery/pkg/watch"

	kcpclient "github.com/kcp-dev/apimachinery/v2/pkg/client"
	"github.com/kcp-dev/logicalcluster/v3"

	kcpapisv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/apis/v1alpha1"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/typed/apis/v1alpha1"
)

// APIConversionsClusterGetter has a method to return a APIConversionClusterInterface.
// A group's cluster client should implement this interface.
type APIConversionsClusterGetter interface {
	APIConversions() APIConversionClusterInterface
}

// APIConversionClusterInterface can operate on APIConversions across all clusters,
// or scope down to one cluster and return a kcpv1alpha1.APIConversionInterface.
type APIConversionClusterInterface interface {
	Cluster(logicalcluster.Path) kcpv1alpha1.APIConversionInterface
	List(ctx context.Context, opts v1.ListOptions) (*kcpapisv1alpha1.APIConversionList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	APIConversionClusterExpansion
}

type aPIConversionsClusterInterface struct {
	clientCache kcpclient.Cache[*kcpv1alpha1.ApisV1alpha1Client]
}

// Cluster scopes the client down to a particular cluster.
func (c *aPIConversionsClusterInterface) Cluster(clusterPath logicalcluster.Path) kcpv1alpha1.APIConversionInterface {
	if clusterPath == logicalcluster.Wildcard {
		panic("A specific cluster must be provided when scoping, not the wildcard.")
	}

	return c.clientCache.ClusterOrDie(clusterPath).APIConversions()
}

// List returns the entire collection of all APIConversions across all clusters.
func (c *aPIConversionsClusterInterface) List(ctx context.Context, opts v1.ListOptions) (*kcpapisv1alpha1.APIConversionList, error) {
	return c.clientCache.ClusterOrDie(logicalcluster.Wildcard).APIConversions().List(ctx, opts)
}

// Watch begins to watch all APIConversions across all clusters.
func (c *aPIConversionsClusterInterface) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.clientCache.ClusterOrDie(logicalcluster.Wildcard).APIConversions().Watch(ctx, opts)
}
