/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"

	wildwestv1alpha1 "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/apis/wildwest/v1alpha1"
	applyconfigurationwildwestv1alpha1 "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/client/applyconfiguration/wildwest/v1alpha1"
	scheme "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/client/clientset/versioned/scheme"
)

// SherifvesGetter has a method to return a SheriffInterface.
// A group's client should implement this interface.
type SherifvesGetter interface {
	Sherifves() SheriffInterface
}

// SheriffInterface has methods to work with Sheriff resources.
type SheriffInterface interface {
	Create(ctx context.Context, sheriff *wildwestv1alpha1.Sheriff, opts v1.CreateOptions) (*wildwestv1alpha1.Sheriff, error)
	Update(ctx context.Context, sheriff *wildwestv1alpha1.Sheriff, opts v1.UpdateOptions) (*wildwestv1alpha1.Sheriff, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, sheriff *wildwestv1alpha1.Sheriff, opts v1.UpdateOptions) (*wildwestv1alpha1.Sheriff, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*wildwestv1alpha1.Sheriff, error)
	List(ctx context.Context, opts v1.ListOptions) (*wildwestv1alpha1.SheriffList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *wildwestv1alpha1.Sheriff, err error)
	Apply(ctx context.Context, sheriff *applyconfigurationwildwestv1alpha1.SheriffApplyConfiguration, opts v1.ApplyOptions) (result *wildwestv1alpha1.Sheriff, err error)
	// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
	ApplyStatus(ctx context.Context, sheriff *applyconfigurationwildwestv1alpha1.SheriffApplyConfiguration, opts v1.ApplyOptions) (result *wildwestv1alpha1.Sheriff, err error)
	SheriffExpansion
}

// sherifves implements SheriffInterface
type sherifves struct {
	*gentype.ClientWithListAndApply[*wildwestv1alpha1.Sheriff, *wildwestv1alpha1.SheriffList, *applyconfigurationwildwestv1alpha1.SheriffApplyConfiguration]
}

// newSherifves returns a Sherifves
func newSherifves(c *WildwestV1alpha1Client) *sherifves {
	return &sherifves{
		gentype.NewClientWithListAndApply[*wildwestv1alpha1.Sheriff, *wildwestv1alpha1.SheriffList, *applyconfigurationwildwestv1alpha1.SheriffApplyConfiguration](
			"sherifves",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *wildwestv1alpha1.Sheriff { return &wildwestv1alpha1.Sheriff{} },
			func() *wildwestv1alpha1.SheriffList { return &wildwestv1alpha1.SheriffList{} },
		),
	}
}
