/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-client-gen. DO NOT EDIT.

package fake

import (
	rest "k8s.io/client-go/rest"

	kcptesting "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/testing"
	"github.com/kcp-dev/logicalcluster/v3"

	kcpwildwestv1alpha1 "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/client/clientset/versioned/cluster/typed/wildwest/v1alpha1"
	wildwestv1alpha1 "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/client/clientset/versioned/typed/wildwest/v1alpha1"
)

var _ kcpwildwestv1alpha1.WildwestV1alpha1ClusterInterface = (*WildwestV1alpha1ClusterClient)(nil)

type WildwestV1alpha1ClusterClient struct {
	*kcptesting.Fake
}

func (c *WildwestV1alpha1ClusterClient) Cluster(clusterPath logicalcluster.Path) wildwestv1alpha1.WildwestV1alpha1Interface {
	if clusterPath == logicalcluster.Wildcard {
		panic("A specific cluster must be provided when scoping, not the wildcard.")
	}
	return &WildwestV1alpha1Client{Fake: c.Fake, ClusterPath: clusterPath}
}

func (c *WildwestV1alpha1ClusterClient) Cowboys() kcpwildwestv1alpha1.CowboyClusterInterface {
	return newFakeCowboyClusterClient(c)
}

func (c *WildwestV1alpha1ClusterClient) Sherifves() kcpwildwestv1alpha1.SheriffClusterInterface {
	return newFakeSheriffClusterClient(c)
}

type WildwestV1alpha1Client struct {
	*kcptesting.Fake
	ClusterPath logicalcluster.Path
}

func (c *WildwestV1alpha1Client) Cowboys(namespace string) wildwestv1alpha1.CowboyInterface {
	return newFakeCowboyClient(c.Fake, namespace, c.ClusterPath)
}

func (c *WildwestV1alpha1Client) Sherifves() wildwestv1alpha1.SheriffInterface {
	return newFakeSheriffClient(c.Fake, c.ClusterPath)
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *WildwestV1alpha1Client) RESTClient() rest.Interface {
	var ret *rest.RESTClient
	return ret
}
