/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package applyconfiguration

import (
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	metav1 "k8s.io/client-go/applyconfigurations/meta/v1"
	testing "k8s.io/client-go/testing"

	v1alpha1 "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/apis/wildwest/v1alpha1"
	internal "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/client/applyconfiguration/internal"
	applyconfigurationmetav1 "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/client/applyconfiguration/meta/v1"
	wildwestv1alpha1 "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/client/applyconfiguration/wildwest/v1alpha1"
)

// ForKind returns an apply configuration type for the given GroupVersionKind, or nil if no
// apply configuration type exists for the given GroupVersionKind.
func ForKind(kind schema.GroupVersionKind) interface{} {
	switch kind {
	// Group=meta.k8s.io, Version=v1
	case v1.SchemeGroupVersion.WithKind("Condition"):
		return &metav1.ConditionApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("DeleteOptions"):
		return &metav1.DeleteOptionsApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("LabelSelector"):
		return &metav1.LabelSelectorApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("LabelSelectorRequirement"):
		return &metav1.LabelSelectorRequirementApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("ManagedFieldsEntry"):
		return &applyconfigurationmetav1.ManagedFieldsEntryApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("ObjectMeta"):
		return &applyconfigurationmetav1.ObjectMetaApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("OwnerReference"):
		return &applyconfigurationmetav1.OwnerReferenceApplyConfiguration{}
	case v1.SchemeGroupVersion.WithKind("TypeMeta"):
		return &applyconfigurationmetav1.TypeMetaApplyConfiguration{}

		// Group=wildwest.dev, Version=v1alpha1
	case v1alpha1.SchemeGroupVersion.WithKind("Cowboy"):
		return &wildwestv1alpha1.CowboyApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("CowboySpec"):
		return &wildwestv1alpha1.CowboySpecApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("CowboyStatus"):
		return &wildwestv1alpha1.CowboyStatusApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("Sheriff"):
		return &wildwestv1alpha1.SheriffApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("SheriffSpec"):
		return &wildwestv1alpha1.SheriffSpecApplyConfiguration{}
	case v1alpha1.SchemeGroupVersion.WithKind("SheriffStatus"):
		return &wildwestv1alpha1.SheriffStatusApplyConfiguration{}

	}
	return nil
}

func NewTypeConverter(scheme *runtime.Scheme) *testing.TypeConverter {
	return &testing.TypeConverter{Scheme: scheme, TypeResolver: internal.Parser()}
}
