/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"

	kcplisters "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/listers"
	"github.com/kcp-dev/logicalcluster/v3"

	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/tenancy/v1alpha1"
)

// WorkspaceClusterLister helps list Workspaces across all workspaces,
// or scope down to a WorkspaceLister for one workspace.
// All objects returned here must be treated as read-only.
type WorkspaceClusterLister interface {
	// List lists all Workspaces in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.Workspace, err error)
	// Cluster returns a lister that can list and get Workspaces in one workspace.
	Cluster(clusterName logicalcluster.Name) WorkspaceLister
	WorkspaceClusterListerExpansion
}

// workspaceClusterLister implements the WorkspaceClusterLister interface.
type workspaceClusterLister struct {
	kcplisters.ResourceClusterIndexer[*kcpv1alpha1.Workspace]
}

var _ WorkspaceClusterLister = new(workspaceClusterLister)

// NewWorkspaceClusterLister returns a new WorkspaceClusterLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewWorkspaceClusterLister(indexer cache.Indexer) WorkspaceClusterLister {
	return &workspaceClusterLister{
		kcplisters.NewCluster[*kcpv1alpha1.Workspace](indexer, kcpv1alpha1.Resource("workspace")),
	}
}

// Cluster scopes the lister to one workspace, allowing users to list and get Workspaces.
func (l *workspaceClusterLister) Cluster(clusterName logicalcluster.Name) WorkspaceLister {
	return &workspaceLister{
		l.ResourceClusterIndexer.WithCluster(clusterName),
	}
}

// workspaceLister can list all Workspaces inside a workspace
// or scope down to a WorkspaceNamespaceLister for one namespace.
type workspaceLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.Workspace]
}

var _ WorkspaceLister = new(workspaceLister)

// WorkspaceLister can list all Workspaces, or get one in particular.
// All objects returned here must be treated as read-only.
type WorkspaceLister interface {
	// List lists all Workspaces in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.Workspace, err error)
	// Get retrieves the Workspace from the indexer for a given workspace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*kcpv1alpha1.Workspace, error)
	WorkspaceListerExpansion
}

// NewWorkspaceLister returns a new WorkspaceLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewWorkspaceLister(indexer cache.Indexer) WorkspaceLister {
	return &workspaceLister{
		kcplisters.New[*kcpv1alpha1.Workspace](indexer, kcpv1alpha1.Resource("workspace")),
	}
}

// workspaceScopedLister can list all Workspaces inside a workspace
// or scope down to a WorkspaceNamespaceLister.
type workspaceScopedLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.Workspace]
}
