/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"

	kcplisters "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/listers"
	"github.com/kcp-dev/logicalcluster/v3"

	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/cache/v1alpha1"
)

// CachedResourceClusterLister helps list CachedResources across all workspaces,
// or scope down to a CachedResourceLister for one workspace.
// All objects returned here must be treated as read-only.
type CachedResourceClusterLister interface {
	// List lists all CachedResources in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.CachedResource, err error)
	// Cluster returns a lister that can list and get CachedResources in one workspace.
	Cluster(clusterName logicalcluster.Name) CachedResourceLister
	CachedResourceClusterListerExpansion
}

// cachedResourceClusterLister implements the CachedResourceClusterLister interface.
type cachedResourceClusterLister struct {
	kcplisters.ResourceClusterIndexer[*kcpv1alpha1.CachedResource]
}

var _ CachedResourceClusterLister = new(cachedResourceClusterLister)

// NewCachedResourceClusterLister returns a new CachedResourceClusterLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewCachedResourceClusterLister(indexer cache.Indexer) CachedResourceClusterLister {
	return &cachedResourceClusterLister{
		kcplisters.NewCluster[*kcpv1alpha1.CachedResource](indexer, kcpv1alpha1.Resource("cachedresource")),
	}
}

// Cluster scopes the lister to one workspace, allowing users to list and get CachedResources.
func (l *cachedResourceClusterLister) Cluster(clusterName logicalcluster.Name) CachedResourceLister {
	return &cachedResourceLister{
		l.ResourceClusterIndexer.WithCluster(clusterName),
	}
}

// cachedResourceLister can list all CachedResources inside a workspace
// or scope down to a CachedResourceNamespaceLister for one namespace.
type cachedResourceLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.CachedResource]
}

var _ CachedResourceLister = new(cachedResourceLister)

// CachedResourceLister can list all CachedResources, or get one in particular.
// All objects returned here must be treated as read-only.
type CachedResourceLister interface {
	// List lists all CachedResources in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.CachedResource, err error)
	// Get retrieves the CachedResource from the indexer for a given workspace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*kcpv1alpha1.CachedResource, error)
	CachedResourceListerExpansion
}

// NewCachedResourceLister returns a new CachedResourceLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewCachedResourceLister(indexer cache.Indexer) CachedResourceLister {
	return &cachedResourceLister{
		kcplisters.New[*kcpv1alpha1.CachedResource](indexer, kcpv1alpha1.Resource("cachedresource")),
	}
}

// cachedResourceScopedLister can list all CachedResources inside a workspace
// or scope down to a CachedResourceNamespaceLister.
type cachedResourceScopedLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.CachedResource]
}
