/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-informer-gen. DO NOT EDIT.

package v1alpha1

import (
	kcpinternalinterfaces "github.com/kcp-dev/kcp/sdk/client/informers/externalversions/internalinterfaces"
)

type ClusterInterface interface {
	// Partitions returns a PartitionClusterInformer.
	Partitions() PartitionClusterInformer
	// PartitionSets returns a PartitionSetClusterInformer.
	PartitionSets() PartitionSetClusterInformer
}

type version struct {
	factory          kcpinternalinterfaces.SharedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// New returns a new Interface.
func New(f kcpinternalinterfaces.SharedInformerFactory, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) ClusterInterface {
	return &version{factory: f, tweakListOptions: tweakListOptions}
}

// Partitions returns a PartitionClusterInformer.
func (v *version) Partitions() PartitionClusterInformer {
	return &partitionClusterInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

// PartitionSets returns a PartitionSetClusterInformer.
func (v *version) PartitionSets() PartitionSetClusterInformer {
	return &partitionSetClusterInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

type Interface interface {
	// Partitions returns a PartitionInformer.
	Partitions() PartitionInformer
	// PartitionSets returns a PartitionSetInformer.
	PartitionSets() PartitionSetInformer
}

type scopedVersion struct {
	factory          kcpinternalinterfaces.SharedScopedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
	namespace        string
}

// New returns a new Interface.
func NewScoped(f kcpinternalinterfaces.SharedScopedInformerFactory, namespace string, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) Interface {
	return &scopedVersion{factory: f, tweakListOptions: tweakListOptions}
}

// Partitions returns a PartitionInformer.
func (v *scopedVersion) Partitions() PartitionInformer {
	return &partitionScopedInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

// PartitionSets returns a PartitionSetInformer.
func (v *scopedVersion) PartitionSets() PartitionSetInformer {
	return &partitionSetScopedInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}
