/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-informer-gen. DO NOT EDIT.

package v1alpha1

import (
	kcpinternalinterfaces "github.com/kcp-dev/kcp/sdk/client/informers/externalversions/internalinterfaces"
)

type ClusterInterface interface {
	// APIBindings returns a APIBindingClusterInformer.
	APIBindings() APIBindingClusterInformer
	// APIConversions returns a APIConversionClusterInformer.
	APIConversions() APIConversionClusterInformer
	// APIExports returns a APIExportClusterInformer.
	APIExports() APIExportClusterInformer
	// APIExportEndpointSlices returns a APIExportEndpointSliceClusterInformer.
	APIExportEndpointSlices() APIExportEndpointSliceClusterInformer
	// APIResourceSchemas returns a APIResourceSchemaClusterInformer.
	APIResourceSchemas() APIResourceSchemaClusterInformer
}

type version struct {
	factory          kcpinternalinterfaces.SharedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// New returns a new Interface.
func New(f kcpinternalinterfaces.SharedInformerFactory, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) ClusterInterface {
	return &version{factory: f, tweakListOptions: tweakListOptions}
}

// APIBindings returns a APIBindingClusterInformer.
func (v *version) APIBindings() APIBindingClusterInformer {
	return &aPIBindingClusterInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

// APIConversions returns a APIConversionClusterInformer.
func (v *version) APIConversions() APIConversionClusterInformer {
	return &aPIConversionClusterInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

// APIExports returns a APIExportClusterInformer.
func (v *version) APIExports() APIExportClusterInformer {
	return &aPIExportClusterInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

// APIExportEndpointSlices returns a APIExportEndpointSliceClusterInformer.
func (v *version) APIExportEndpointSlices() APIExportEndpointSliceClusterInformer {
	return &aPIExportEndpointSliceClusterInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

// APIResourceSchemas returns a APIResourceSchemaClusterInformer.
func (v *version) APIResourceSchemas() APIResourceSchemaClusterInformer {
	return &aPIResourceSchemaClusterInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

type Interface interface {
	// APIBindings returns a APIBindingInformer.
	APIBindings() APIBindingInformer
	// APIConversions returns a APIConversionInformer.
	APIConversions() APIConversionInformer
	// APIExports returns a APIExportInformer.
	APIExports() APIExportInformer
	// APIExportEndpointSlices returns a APIExportEndpointSliceInformer.
	APIExportEndpointSlices() APIExportEndpointSliceInformer
	// APIResourceSchemas returns a APIResourceSchemaInformer.
	APIResourceSchemas() APIResourceSchemaInformer
}

type scopedVersion struct {
	factory          kcpinternalinterfaces.SharedScopedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
	namespace        string
}

// New returns a new Interface.
func NewScoped(f kcpinternalinterfaces.SharedScopedInformerFactory, namespace string, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) Interface {
	return &scopedVersion{factory: f, tweakListOptions: tweakListOptions}
}

// APIBindings returns a APIBindingInformer.
func (v *scopedVersion) APIBindings() APIBindingInformer {
	return &aPIBindingScopedInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

// APIConversions returns a APIConversionInformer.
func (v *scopedVersion) APIConversions() APIConversionInformer {
	return &aPIConversionScopedInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

// APIExports returns a APIExportInformer.
func (v *scopedVersion) APIExports() APIExportInformer {
	return &aPIExportScopedInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

// APIExportEndpointSlices returns a APIExportEndpointSliceInformer.
func (v *scopedVersion) APIExportEndpointSlices() APIExportEndpointSliceInformer {
	return &aPIExportEndpointSliceScopedInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

// APIResourceSchemas returns a APIResourceSchemaInformer.
func (v *scopedVersion) APIResourceSchemas() APIResourceSchemaInformer {
	return &aPIResourceSchemaScopedInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}
