/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-client-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	watch "k8s.io/apimachinery/pkg/watch"

	kcpclient "github.com/kcp-dev/apimachinery/v2/pkg/client"
	"github.com/kcp-dev/logicalcluster/v3"

	kcpcorev1alpha1 "github.com/kcp-dev/kcp/sdk/apis/core/v1alpha1"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/typed/core/v1alpha1"
)

// LogicalClustersClusterGetter has a method to return a LogicalClusterClusterInterface.
// A group's cluster client should implement this interface.
type LogicalClustersClusterGetter interface {
	LogicalClusters() LogicalClusterClusterInterface
}

// LogicalClusterClusterInterface can operate on LogicalClusters across all clusters,
// or scope down to one cluster and return a kcpv1alpha1.LogicalClusterInterface.
type LogicalClusterClusterInterface interface {
	Cluster(logicalcluster.Path) kcpv1alpha1.LogicalClusterInterface
	List(ctx context.Context, opts v1.ListOptions) (*kcpcorev1alpha1.LogicalClusterList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	LogicalClusterClusterExpansion
}

type logicalClustersClusterInterface struct {
	clientCache kcpclient.Cache[*kcpv1alpha1.CoreV1alpha1Client]
}

// Cluster scopes the client down to a particular cluster.
func (c *logicalClustersClusterInterface) Cluster(clusterPath logicalcluster.Path) kcpv1alpha1.LogicalClusterInterface {
	if clusterPath == logicalcluster.Wildcard {
		panic("A specific cluster must be provided when scoping, not the wildcard.")
	}

	return c.clientCache.ClusterOrDie(clusterPath).LogicalClusters()
}

// List returns the entire collection of all LogicalClusters across all clusters.
func (c *logicalClustersClusterInterface) List(ctx context.Context, opts v1.ListOptions) (*kcpcorev1alpha1.LogicalClusterList, error) {
	return c.clientCache.ClusterOrDie(logicalcluster.Wildcard).LogicalClusters().List(ctx, opts)
}

// Watch begins to watch all LogicalClusters across all clusters.
func (c *logicalClustersClusterInterface) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.clientCache.ClusterOrDie(logicalcluster.Wildcard).LogicalClusters().Watch(ctx, opts)
}
