/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-client-gen. DO NOT EDIT.

package fake

import (
	kcpgentype "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/gentype"
	kcptesting "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/testing"
	"github.com/kcp-dev/logicalcluster/v3"

	apisv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/apis/v1alpha1"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/applyconfiguration/apis/v1alpha1"
	typedkcpapisv1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster/typed/apis/v1alpha1"
	typedapisv1alpha1 "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/typed/apis/v1alpha1"
)

// aPIConversionClusterClient implements APIConversionClusterInterface
type aPIConversionClusterClient struct {
	*kcpgentype.FakeClusterClientWithList[*apisv1alpha1.APIConversion, *apisv1alpha1.APIConversionList]
	Fake *kcptesting.Fake
}

func newFakeAPIConversionClusterClient(fake *ApisV1alpha1ClusterClient) typedkcpapisv1alpha1.APIConversionClusterInterface {
	return &aPIConversionClusterClient{
		kcpgentype.NewFakeClusterClientWithList[*apisv1alpha1.APIConversion, *apisv1alpha1.APIConversionList](
			fake.Fake,
			apisv1alpha1.SchemeGroupVersion.WithResource("apiconversions"),
			apisv1alpha1.SchemeGroupVersion.WithKind("APIConversion"),
			func() *apisv1alpha1.APIConversion { return &apisv1alpha1.APIConversion{} },
			func() *apisv1alpha1.APIConversionList { return &apisv1alpha1.APIConversionList{} },
			func(dst, src *apisv1alpha1.APIConversionList) { dst.ListMeta = src.ListMeta },
			func(list *apisv1alpha1.APIConversionList) []*apisv1alpha1.APIConversion {
				return kcpgentype.ToPointerSlice(list.Items)
			},
			func(list *apisv1alpha1.APIConversionList, items []*apisv1alpha1.APIConversion) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake.Fake,
	}
}

func (c *aPIConversionClusterClient) Cluster(cluster logicalcluster.Path) typedapisv1alpha1.APIConversionInterface {
	return newFakeAPIConversionClient(c.Fake, cluster)
}

// aPIConversionScopedClient implements APIConversionInterface
type aPIConversionScopedClient struct {
	*kcpgentype.FakeClientWithListAndApply[*apisv1alpha1.APIConversion, *apisv1alpha1.APIConversionList, *kcpv1alpha1.APIConversionApplyConfiguration]
	Fake        *kcptesting.Fake
	ClusterPath logicalcluster.Path
}

func newFakeAPIConversionClient(fake *kcptesting.Fake, clusterPath logicalcluster.Path) typedapisv1alpha1.APIConversionInterface {
	return &aPIConversionScopedClient{
		kcpgentype.NewFakeClientWithListAndApply[*apisv1alpha1.APIConversion, *apisv1alpha1.APIConversionList, *kcpv1alpha1.APIConversionApplyConfiguration](
			fake,
			clusterPath,
			"",
			apisv1alpha1.SchemeGroupVersion.WithResource("apiconversions"),
			apisv1alpha1.SchemeGroupVersion.WithKind("APIConversion"),
			func() *apisv1alpha1.APIConversion { return &apisv1alpha1.APIConversion{} },
			func() *apisv1alpha1.APIConversionList { return &apisv1alpha1.APIConversionList{} },
			func(dst, src *apisv1alpha1.APIConversionList) { dst.ListMeta = src.ListMeta },
			func(list *apisv1alpha1.APIConversionList) []*apisv1alpha1.APIConversion {
				return kcpgentype.ToPointerSlice(list.Items)
			},
			func(list *apisv1alpha1.APIConversionList, items []*apisv1alpha1.APIConversion) {
				list.Items = kcpgentype.FromPointerSlice(items)
			},
		),
		fake,
		clusterPath,
	}
}
