/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	v1 "github.com/kcp-dev/kcp/sdk/client/applyconfiguration/meta/v1"
)

// PartitionSetSpecApplyConfiguration represents a declarative configuration of the PartitionSetSpec type for use
// with apply.
type PartitionSetSpecApplyConfiguration struct {
	Dimensions    []string                            `json:"dimensions,omitempty"`
	ShardSelector *v1.LabelSelectorApplyConfiguration `json:"shardSelector,omitempty"`
}

// PartitionSetSpecApplyConfiguration constructs a declarative configuration of the PartitionSetSpec type for use with
// apply.
func PartitionSetSpec() *PartitionSetSpecApplyConfiguration {
	return &PartitionSetSpecApplyConfiguration{}
}

// WithDimensions adds the given value to the Dimensions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Dimensions field.
func (b *PartitionSetSpecApplyConfiguration) WithDimensions(values ...string) *PartitionSetSpecApplyConfiguration {
	for i := range values {
		b.Dimensions = append(b.Dimensions, values[i])
	}
	return b
}

// WithShardSelector sets the ShardSelector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ShardSelector field is set to the value of the last call.
func (b *PartitionSetSpecApplyConfiguration) WithShardSelector(value *v1.LabelSelectorApplyConfiguration) *PartitionSetSpecApplyConfiguration {
	b.ShardSelector = value
	return b
}
