/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	corev1alpha1 "github.com/kcp-dev/kcp/sdk/apis/core/v1alpha1"
)

// LogicalClusterSpecApplyConfiguration represents a declarative configuration of the LogicalClusterSpec type for use
// with apply.
type LogicalClusterSpecApplyConfiguration struct {
	DirectlyDeletable *bool                                    `json:"directlyDeletable,omitempty"`
	Owner             *LogicalClusterOwnerApplyConfiguration   `json:"owner,omitempty"`
	Initializers      []corev1alpha1.LogicalClusterInitializer `json:"initializers,omitempty"`
}

// LogicalClusterSpecApplyConfiguration constructs a declarative configuration of the LogicalClusterSpec type for use with
// apply.
func LogicalClusterSpec() *LogicalClusterSpecApplyConfiguration {
	return &LogicalClusterSpecApplyConfiguration{}
}

// WithDirectlyDeletable sets the DirectlyDeletable field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DirectlyDeletable field is set to the value of the last call.
func (b *LogicalClusterSpecApplyConfiguration) WithDirectlyDeletable(value bool) *LogicalClusterSpecApplyConfiguration {
	b.DirectlyDeletable = &value
	return b
}

// WithOwner sets the Owner field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Owner field is set to the value of the last call.
func (b *LogicalClusterSpecApplyConfiguration) WithOwner(value *LogicalClusterOwnerApplyConfiguration) *LogicalClusterSpecApplyConfiguration {
	b.Owner = value
	return b
}

// WithInitializers adds the given value to the Initializers field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Initializers field.
func (b *LogicalClusterSpecApplyConfiguration) WithInitializers(values ...corev1alpha1.LogicalClusterInitializer) *LogicalClusterSpecApplyConfiguration {
	for i := range values {
		b.Initializers = append(b.Initializers, values[i])
	}
	return b
}
