/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha2

import (
	v1 "github.com/kcp-dev/kcp/sdk/client/applyconfiguration/meta/v1"
)

// PermissionClaimSelectorApplyConfiguration represents a declarative configuration of the PermissionClaimSelector type for use
// with apply.
type PermissionClaimSelectorApplyConfiguration struct {
	v1.LabelSelectorApplyConfiguration `json:",inline"`
	MatchAll                           *bool `json:"matchAll,omitempty"`
}

// PermissionClaimSelectorApplyConfiguration constructs a declarative configuration of the PermissionClaimSelector type for use with
// apply.
func PermissionClaimSelector() *PermissionClaimSelectorApplyConfiguration {
	return &PermissionClaimSelectorApplyConfiguration{}
}

// WithMatchLabels puts the entries into the MatchLabels field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the MatchLabels field,
// overwriting an existing map entries in MatchLabels field with the same key.
func (b *PermissionClaimSelectorApplyConfiguration) WithMatchLabels(entries map[string]string) *PermissionClaimSelectorApplyConfiguration {
	if b.LabelSelectorApplyConfiguration.MatchLabels == nil && len(entries) > 0 {
		b.LabelSelectorApplyConfiguration.MatchLabels = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.LabelSelectorApplyConfiguration.MatchLabels[k] = v
	}
	return b
}

// WithMatchExpressions adds the given value to the MatchExpressions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the MatchExpressions field.
func (b *PermissionClaimSelectorApplyConfiguration) WithMatchExpressions(values ...*v1.LabelSelectorRequirementApplyConfiguration) *PermissionClaimSelectorApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithMatchExpressions")
		}
		b.LabelSelectorApplyConfiguration.MatchExpressions = append(b.LabelSelectorApplyConfiguration.MatchExpressions, *values[i])
	}
	return b
}

// WithMatchAll sets the MatchAll field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MatchAll field is set to the value of the last call.
func (b *PermissionClaimSelectorApplyConfiguration) WithMatchAll(value bool) *PermissionClaimSelectorApplyConfiguration {
	b.MatchAll = &value
	return b
}
