/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"

	kcplisters "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/listers"
	"github.com/kcp-dev/logicalcluster/v3"

	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/apis/v1alpha1"
)

// APIExportEndpointSliceClusterLister helps list APIExportEndpointSlices across all workspaces,
// or scope down to a APIExportEndpointSliceLister for one workspace.
// All objects returned here must be treated as read-only.
type APIExportEndpointSliceClusterLister interface {
	// List lists all APIExportEndpointSlices in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.APIExportEndpointSlice, err error)
	// Cluster returns a lister that can list and get APIExportEndpointSlices in one workspace.
	Cluster(clusterName logicalcluster.Name) APIExportEndpointSliceLister
	APIExportEndpointSliceClusterListerExpansion
}

// aPIExportEndpointSliceClusterLister implements the APIExportEndpointSliceClusterLister interface.
type aPIExportEndpointSliceClusterLister struct {
	kcplisters.ResourceClusterIndexer[*kcpv1alpha1.APIExportEndpointSlice]
}

var _ APIExportEndpointSliceClusterLister = new(aPIExportEndpointSliceClusterLister)

// NewAPIExportEndpointSliceClusterLister returns a new APIExportEndpointSliceClusterLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewAPIExportEndpointSliceClusterLister(indexer cache.Indexer) APIExportEndpointSliceClusterLister {
	return &aPIExportEndpointSliceClusterLister{
		kcplisters.NewCluster[*kcpv1alpha1.APIExportEndpointSlice](indexer, kcpv1alpha1.Resource("apiexportendpointslice")),
	}
}

// Cluster scopes the lister to one workspace, allowing users to list and get APIExportEndpointSlices.
func (l *aPIExportEndpointSliceClusterLister) Cluster(clusterName logicalcluster.Name) APIExportEndpointSliceLister {
	return &aPIExportEndpointSliceLister{
		l.ResourceClusterIndexer.WithCluster(clusterName),
	}
}

// aPIExportEndpointSliceLister can list all APIExportEndpointSlices inside a workspace
// or scope down to a APIExportEndpointSliceNamespaceLister for one namespace.
type aPIExportEndpointSliceLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.APIExportEndpointSlice]
}

var _ APIExportEndpointSliceLister = new(aPIExportEndpointSliceLister)

// APIExportEndpointSliceLister can list all APIExportEndpointSlices, or get one in particular.
// All objects returned here must be treated as read-only.
type APIExportEndpointSliceLister interface {
	// List lists all APIExportEndpointSlices in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.APIExportEndpointSlice, err error)
	// Get retrieves the APIExportEndpointSlice from the indexer for a given workspace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*kcpv1alpha1.APIExportEndpointSlice, error)
	APIExportEndpointSliceListerExpansion
}

// NewAPIExportEndpointSliceLister returns a new APIExportEndpointSliceLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewAPIExportEndpointSliceLister(indexer cache.Indexer) APIExportEndpointSliceLister {
	return &aPIExportEndpointSliceLister{
		kcplisters.New[*kcpv1alpha1.APIExportEndpointSlice](indexer, kcpv1alpha1.Resource("apiexportendpointslice")),
	}
}

// aPIExportEndpointSliceScopedLister can list all APIExportEndpointSlices inside a workspace
// or scope down to a APIExportEndpointSliceNamespaceLister.
type aPIExportEndpointSliceScopedLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.APIExportEndpointSlice]
}
