/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"

	kcplisters "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/listers"
	"github.com/kcp-dev/logicalcluster/v3"

	kcpv1alpha1 "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/apis/wildwest/v1alpha1"
)

// CowboyClusterLister helps list Cowboys across all workspaces,
// or scope down to a CowboyLister for one workspace.
// All objects returned here must be treated as read-only.
type CowboyClusterLister interface {
	// List lists all Cowboys in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.Cowboy, err error)
	// Cluster returns a lister that can list and get Cowboys in one workspace.
	Cluster(clusterName logicalcluster.Name) CowboyLister
	CowboyClusterListerExpansion
}

// cowboyClusterLister implements the CowboyClusterLister interface.
type cowboyClusterLister struct {
	kcplisters.ResourceClusterIndexer[*kcpv1alpha1.Cowboy]
}

var _ CowboyClusterLister = new(cowboyClusterLister)

// NewCowboyClusterLister returns a new CowboyClusterLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
// - has the kcpcache.ClusterAndNamespaceIndex as an index
func NewCowboyClusterLister(indexer cache.Indexer) CowboyClusterLister {
	return &cowboyClusterLister{
		kcplisters.NewCluster[*kcpv1alpha1.Cowboy](indexer, kcpv1alpha1.Resource("cowboy")),
	}
}

// Cluster scopes the lister to one workspace, allowing users to list and get Cowboys.
func (l *cowboyClusterLister) Cluster(clusterName logicalcluster.Name) CowboyLister {
	return &cowboyLister{
		l.ResourceClusterIndexer.WithCluster(clusterName),
	}
}

// cowboyLister can list all Cowboys inside a workspace
// or scope down to a CowboyNamespaceLister for one namespace.
type cowboyLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.Cowboy]
}

var _ CowboyLister = new(cowboyLister)

// CowboyLister can list Cowboys across all namespaces, or scope down to a CowboyNamespaceLister for one namespace.
// All objects returned here must be treated as read-only.
type CowboyLister interface {
	// List lists all Cowboys in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.Cowboy, err error)
	// Cowboys returns a lister that can list and get Cowboys in one workspace and namespace.
	Cowboys(namespace string) CowboyNamespaceLister
	CowboyListerExpansion
}

// Cowboys returns an object that can list and get Cowboys in one namespace.
func (l *cowboyLister) Cowboys(namespace string) CowboyNamespaceLister {
	return &cowboyNamespaceLister{
		l.ResourceIndexer.WithNamespace(namespace),
	}
}

// cowboyNamespaceLister implements the CowboyNamespaceLister
// interface.
type cowboyNamespaceLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.Cowboy]
}

var _ CowboyNamespaceLister = new(cowboyNamespaceLister)

// CowboyNamespaceLister can list all Cowboys, or get one in particular.
// All objects returned here must be treated as read-only.
type CowboyNamespaceLister interface {
	// List lists all Cowboys in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.Cowboy, err error)
	// Get retrieves the Cowboy from the indexer for a given workspace, namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*kcpv1alpha1.Cowboy, error)
	CowboyNamespaceListerExpansion
}

// NewCowboyLister returns a new CowboyLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
// - has the kcpcache.ClusterAndNamespaceIndex as an index
func NewCowboyLister(indexer cache.Indexer) CowboyLister {
	return &cowboyLister{
		kcplisters.New[*kcpv1alpha1.Cowboy](indexer, kcpv1alpha1.Resource("cowboy")),
	}
}

// cowboyScopedLister can list all Cowboys inside a workspace
// or scope down to a CowboyNamespaceLister for one namespace.
type cowboyScopedLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.Cowboy]
}

// Cowboys returns an object that can list and get Cowboys in one namespace.
func (l *cowboyScopedLister) Cowboys(namespace string) CowboyLister {
	return &cowboyLister{
		l.ResourceIndexer.WithNamespace(namespace),
	}
}
