/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-informer-gen. DO NOT EDIT.

package v1alpha1

import (
	kcpinternalinterfaces "github.com/kcp-dev/kcp/test/e2e/fixtures/wildwest/client/informers/externalversions/internalinterfaces"
)

type ClusterInterface interface {
	// Cowboys returns a CowboyClusterInformer.
	Cowboys() CowboyClusterInformer
	// Sherifves returns a SheriffClusterInformer.
	Sherifves() SheriffClusterInformer
}

type version struct {
	factory          kcpinternalinterfaces.SharedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// New returns a new Interface.
func New(f kcpinternalinterfaces.SharedInformerFactory, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) ClusterInterface {
	return &version{factory: f, tweakListOptions: tweakListOptions}
}

// Cowboys returns a CowboyClusterInformer.
func (v *version) Cowboys() CowboyClusterInformer {
	return &cowboyClusterInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

// Sherifves returns a SheriffClusterInformer.
func (v *version) Sherifves() SheriffClusterInformer {
	return &sheriffClusterInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}

type Interface interface {
	// Cowboys returns a CowboyInformer.
	Cowboys() CowboyInformer
	// Sherifves returns a SheriffInformer.
	Sherifves() SheriffInformer
}

type scopedVersion struct {
	factory          kcpinternalinterfaces.SharedScopedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
	namespace        string
}

// New returns a new Interface.
func NewScoped(f kcpinternalinterfaces.SharedScopedInformerFactory, namespace string, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) Interface {
	return &scopedVersion{factory: f, tweakListOptions: tweakListOptions}
}

// Cowboys returns a CowboyInformer.
func (v *scopedVersion) Cowboys() CowboyInformer {
	return &cowboyScopedInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// Sherifves returns a SheriffInformer.
func (v *scopedVersion) Sherifves() SheriffInformer {
	return &sheriffScopedInformer{factory: v.factory, tweakListOptions: v.tweakListOptions}
}
