/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"

	kcplisters "github.com/kcp-dev/client-go/third_party/k8s.io/client-go/listers"
	"github.com/kcp-dev/logicalcluster/v3"

	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/cache/v1alpha1"
)

// CachedObjectClusterLister helps list CachedObjects across all workspaces,
// or scope down to a CachedObjectLister for one workspace.
// All objects returned here must be treated as read-only.
type CachedObjectClusterLister interface {
	// List lists all CachedObjects in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.CachedObject, err error)
	// Cluster returns a lister that can list and get CachedObjects in one workspace.
	Cluster(clusterName logicalcluster.Name) CachedObjectLister
	CachedObjectClusterListerExpansion
}

// cachedObjectClusterLister implements the CachedObjectClusterLister interface.
type cachedObjectClusterLister struct {
	kcplisters.ResourceClusterIndexer[*kcpv1alpha1.CachedObject]
}

var _ CachedObjectClusterLister = new(cachedObjectClusterLister)

// NewCachedObjectClusterLister returns a new CachedObjectClusterLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewCachedObjectClusterLister(indexer cache.Indexer) CachedObjectClusterLister {
	return &cachedObjectClusterLister{
		kcplisters.NewCluster[*kcpv1alpha1.CachedObject](indexer, kcpv1alpha1.Resource("cachedobject")),
	}
}

// Cluster scopes the lister to one workspace, allowing users to list and get CachedObjects.
func (l *cachedObjectClusterLister) Cluster(clusterName logicalcluster.Name) CachedObjectLister {
	return &cachedObjectLister{
		l.ResourceClusterIndexer.WithCluster(clusterName),
	}
}

// cachedObjectLister can list all CachedObjects inside a workspace
// or scope down to a CachedObjectNamespaceLister for one namespace.
type cachedObjectLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.CachedObject]
}

var _ CachedObjectLister = new(cachedObjectLister)

// CachedObjectLister can list all CachedObjects, or get one in particular.
// All objects returned here must be treated as read-only.
type CachedObjectLister interface {
	// List lists all CachedObjects in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*kcpv1alpha1.CachedObject, err error)
	// Get retrieves the CachedObject from the indexer for a given workspace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*kcpv1alpha1.CachedObject, error)
	CachedObjectListerExpansion
}

// NewCachedObjectLister returns a new CachedObjectLister.
// We assume that the indexer:
// - is fed by a cross-workspace LIST+WATCH
// - uses kcpcache.MetaClusterNamespaceKeyFunc as the key function
// - has the kcpcache.ClusterIndex as an index
func NewCachedObjectLister(indexer cache.Indexer) CachedObjectLister {
	return &cachedObjectLister{
		kcplisters.New[*kcpv1alpha1.CachedObject](indexer, kcpv1alpha1.Resource("cachedobject")),
	}
}

// cachedObjectScopedLister can list all CachedObjects inside a workspace
// or scope down to a CachedObjectNamespaceLister.
type cachedObjectScopedLister struct {
	kcplisters.ResourceIndexer[*kcpv1alpha1.CachedObject]
}
