/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-informer-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"

	kcpcache "github.com/kcp-dev/apimachinery/v2/pkg/cache"
	kcpinformers "github.com/kcp-dev/apimachinery/v2/third_party/informers"
	logicalcluster "github.com/kcp-dev/logicalcluster/v3"

	kcptopologyv1alpha1 "github.com/kcp-dev/kcp/sdk/apis/topology/v1alpha1"
	kcpversioned "github.com/kcp-dev/kcp/sdk/client/clientset/versioned"
	kcpcluster "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster"
	kcpinternalinterfaces "github.com/kcp-dev/kcp/sdk/client/informers/externalversions/internalinterfaces"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/listers/topology/v1alpha1"
)

// PartitionClusterInformer provides access to a shared informer and lister for
// Partitions.
type PartitionClusterInformer interface {
	Cluster(logicalcluster.Name) PartitionInformer
	ClusterWithContext(context.Context, logicalcluster.Name) PartitionInformer
	Informer() kcpcache.ScopeableSharedIndexInformer
	Lister() kcpv1alpha1.PartitionClusterLister
}

type partitionClusterInformer struct {
	factory          kcpinternalinterfaces.SharedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewPartitionClusterInformer constructs a new informer for Partition type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewPartitionClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredPartitionClusterInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredPartitionClusterInformer constructs a new informer for Partition type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredPartitionClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) kcpcache.ScopeableSharedIndexInformer {
	return kcpinformers.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.TopologyV1alpha1().Partitions().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.TopologyV1alpha1().Partitions().Watch(context.Background(), options)
			},
		},
		&kcptopologyv1alpha1.Partition{},
		resyncPeriod,
		indexers,
	)
}

func (i *partitionClusterInformer) defaultInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredPartitionClusterInformer(client, resyncPeriod, cache.Indexers{
		kcpcache.ClusterIndexName:             kcpcache.ClusterIndexFunc,
		kcpcache.ClusterAndNamespaceIndexName: kcpcache.ClusterAndNamespaceIndexFunc,
	}, i.tweakListOptions)
}

func (i *partitionClusterInformer) Informer() kcpcache.ScopeableSharedIndexInformer {
	return i.factory.InformerFor(&kcptopologyv1alpha1.Partition{}, i.defaultInformer)
}

func (i *partitionClusterInformer) Lister() kcpv1alpha1.PartitionClusterLister {
	return kcpv1alpha1.NewPartitionClusterLister(i.Informer().GetIndexer())
}

func (i *partitionClusterInformer) Cluster(clusterName logicalcluster.Name) PartitionInformer {
	return &partitionInformer{
		informer: i.Informer().Cluster(clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

func (i *partitionClusterInformer) ClusterWithContext(ctx context.Context, clusterName logicalcluster.Name) PartitionInformer {
	return &partitionInformer{
		informer: i.Informer().ClusterWithContext(ctx, clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

type partitionInformer struct {
	informer cache.SharedIndexInformer
	lister   kcpv1alpha1.PartitionLister
}

func (i *partitionInformer) Informer() cache.SharedIndexInformer {
	return i.informer
}

func (i *partitionInformer) Lister() kcpv1alpha1.PartitionLister {
	return i.lister
}

// PartitionInformer provides access to a shared informer and lister for
// Partitions.
type PartitionInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() kcpv1alpha1.PartitionLister
}

type partitionScopedInformer struct {
	factory          kcpinternalinterfaces.SharedScopedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewPartitionInformer constructs a new informer for Partition type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewPartitionInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredPartitionInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredPartitionInformer constructs a new informer for Partition type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredPartitionInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.TopologyV1alpha1().Partitions().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.TopologyV1alpha1().Partitions().Watch(context.Background(), options)
			},
		},
		&kcptopologyv1alpha1.Partition{},
		resyncPeriod,
		indexers,
	)
}

func (i *partitionScopedInformer) Informer() cache.SharedIndexInformer {
	return i.factory.InformerFor(&kcptopologyv1alpha1.Partition{}, i.defaultInformer)
}

func (i *partitionScopedInformer) Lister() kcpv1alpha1.PartitionLister {
	return kcpv1alpha1.NewPartitionLister(i.Informer().GetIndexer())
}

func (i *partitionScopedInformer) defaultInformer(client kcpversioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredPartitionInformer(client, resyncPeriod, cache.Indexers{}, i.tweakListOptions)
}
