/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-informer-gen. DO NOT EDIT.

package topology

import (
	kcpinternalinterfaces "github.com/kcp-dev/kcp/sdk/client/informers/externalversions/internalinterfaces"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/informers/externalversions/topology/v1alpha1"
)

// ClusterInterface provides access to each of this group's versions.
type ClusterInterface interface {
	// V1alpha1 provides access to shared informers for resources in V1alpha1.
	V1alpha1() kcpv1alpha1.ClusterInterface
}

type group struct {
	factory          kcpinternalinterfaces.SharedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// New returns a new ClusterInterface.
func New(f kcpinternalinterfaces.SharedInformerFactory, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) ClusterInterface {
	return &group{factory: f, tweakListOptions: tweakListOptions}
}

// V1alpha1 returns a new kcpv1alpha1.ClusterInterface.
func (g *group) V1alpha1() kcpv1alpha1.ClusterInterface {
	return kcpv1alpha1.New(g.factory, g.tweakListOptions)
}

// Interface provides access to each of this group's versions.
type Interface interface {
	// V1alpha1 provides access to shared informers for resources in V1alpha1.
	V1alpha1() kcpv1alpha1.Interface
}

type scopedGroup struct {
	factory          kcpinternalinterfaces.SharedScopedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
	namespace        string
}

// New returns a new Interface.
func NewScoped(f kcpinternalinterfaces.SharedScopedInformerFactory, namespace string, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) Interface {
	return &scopedGroup{factory: f, namespace: namespace, tweakListOptions: tweakListOptions}
}

// V1alpha1 returns a new kcpv1alpha1.Interface.
func (g *scopedGroup) V1alpha1() kcpv1alpha1.Interface {
	return kcpv1alpha1.NewScoped(g.factory, g.namespace, g.tweakListOptions)
}
