/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by cluster-informer-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"

	kcpcache "github.com/kcp-dev/apimachinery/v2/pkg/cache"
	kcpinformers "github.com/kcp-dev/apimachinery/v2/third_party/informers"
	logicalcluster "github.com/kcp-dev/logicalcluster/v3"

	kcpcorev1alpha1 "github.com/kcp-dev/kcp/sdk/apis/core/v1alpha1"
	kcpversioned "github.com/kcp-dev/kcp/sdk/client/clientset/versioned"
	kcpcluster "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/cluster"
	kcpinternalinterfaces "github.com/kcp-dev/kcp/sdk/client/informers/externalversions/internalinterfaces"
	kcpv1alpha1 "github.com/kcp-dev/kcp/sdk/client/listers/core/v1alpha1"
)

// ShardClusterInformer provides access to a shared informer and lister for
// Shards.
type ShardClusterInformer interface {
	Cluster(logicalcluster.Name) ShardInformer
	ClusterWithContext(context.Context, logicalcluster.Name) ShardInformer
	Informer() kcpcache.ScopeableSharedIndexInformer
	Lister() kcpv1alpha1.ShardClusterLister
}

type shardClusterInformer struct {
	factory          kcpinternalinterfaces.SharedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewShardClusterInformer constructs a new informer for Shard type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewShardClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredShardClusterInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredShardClusterInformer constructs a new informer for Shard type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredShardClusterInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) kcpcache.ScopeableSharedIndexInformer {
	return kcpinformers.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.CoreV1alpha1().Shards().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.CoreV1alpha1().Shards().Watch(context.Background(), options)
			},
		},
		&kcpcorev1alpha1.Shard{},
		resyncPeriod,
		indexers,
	)
}

func (i *shardClusterInformer) defaultInformer(client kcpcluster.ClusterInterface, resyncPeriod time.Duration) kcpcache.ScopeableSharedIndexInformer {
	return NewFilteredShardClusterInformer(client, resyncPeriod, cache.Indexers{
		kcpcache.ClusterIndexName:             kcpcache.ClusterIndexFunc,
		kcpcache.ClusterAndNamespaceIndexName: kcpcache.ClusterAndNamespaceIndexFunc,
	}, i.tweakListOptions)
}

func (i *shardClusterInformer) Informer() kcpcache.ScopeableSharedIndexInformer {
	return i.factory.InformerFor(&kcpcorev1alpha1.Shard{}, i.defaultInformer)
}

func (i *shardClusterInformer) Lister() kcpv1alpha1.ShardClusterLister {
	return kcpv1alpha1.NewShardClusterLister(i.Informer().GetIndexer())
}

func (i *shardClusterInformer) Cluster(clusterName logicalcluster.Name) ShardInformer {
	return &shardInformer{
		informer: i.Informer().Cluster(clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

func (i *shardClusterInformer) ClusterWithContext(ctx context.Context, clusterName logicalcluster.Name) ShardInformer {
	return &shardInformer{
		informer: i.Informer().ClusterWithContext(ctx, clusterName),
		lister:   i.Lister().Cluster(clusterName),
	}
}

type shardInformer struct {
	informer cache.SharedIndexInformer
	lister   kcpv1alpha1.ShardLister
}

func (i *shardInformer) Informer() cache.SharedIndexInformer {
	return i.informer
}

func (i *shardInformer) Lister() kcpv1alpha1.ShardLister {
	return i.lister
}

// ShardInformer provides access to a shared informer and lister for
// Shards.
type ShardInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() kcpv1alpha1.ShardLister
}

type shardScopedInformer struct {
	factory          kcpinternalinterfaces.SharedScopedInformerFactory
	tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc
}

// NewShardInformer constructs a new informer for Shard type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewShardInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredShardInformer(client, resyncPeriod, indexers, nil)
}

// NewFilteredShardInformer constructs a new informer for Shard type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredShardInformer(client kcpversioned.Interface, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions kcpinternalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.CoreV1alpha1().Shards().List(context.Background(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.CoreV1alpha1().Shards().Watch(context.Background(), options)
			},
		},
		&kcpcorev1alpha1.Shard{},
		resyncPeriod,
		indexers,
	)
}

func (i *shardScopedInformer) Informer() cache.SharedIndexInformer {
	return i.factory.InformerFor(&kcpcorev1alpha1.Shard{}, i.defaultInformer)
}

func (i *shardScopedInformer) Lister() kcpv1alpha1.ShardLister {
	return kcpv1alpha1.NewShardLister(i.Informer().GetIndexer())
}

func (i *shardScopedInformer) defaultInformer(client kcpversioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredShardInformer(client, resyncPeriod, cache.Indexers{}, i.tweakListOptions)
}
