/*
Copyright The KCP Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"

	corev1alpha1 "github.com/kcp-dev/kcp/sdk/apis/core/v1alpha1"
	applyconfigurationcorev1alpha1 "github.com/kcp-dev/kcp/sdk/client/applyconfiguration/core/v1alpha1"
	scheme "github.com/kcp-dev/kcp/sdk/client/clientset/versioned/scheme"
)

// ShardsGetter has a method to return a ShardInterface.
// A group's client should implement this interface.
type ShardsGetter interface {
	Shards() ShardInterface
}

// ShardInterface has methods to work with Shard resources.
type ShardInterface interface {
	Create(ctx context.Context, shard *corev1alpha1.Shard, opts v1.CreateOptions) (*corev1alpha1.Shard, error)
	Update(ctx context.Context, shard *corev1alpha1.Shard, opts v1.UpdateOptions) (*corev1alpha1.Shard, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, shard *corev1alpha1.Shard, opts v1.UpdateOptions) (*corev1alpha1.Shard, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*corev1alpha1.Shard, error)
	List(ctx context.Context, opts v1.ListOptions) (*corev1alpha1.ShardList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *corev1alpha1.Shard, err error)
	Apply(ctx context.Context, shard *applyconfigurationcorev1alpha1.ShardApplyConfiguration, opts v1.ApplyOptions) (result *corev1alpha1.Shard, err error)
	// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
	ApplyStatus(ctx context.Context, shard *applyconfigurationcorev1alpha1.ShardApplyConfiguration, opts v1.ApplyOptions) (result *corev1alpha1.Shard, err error)
	ShardExpansion
}

// shards implements ShardInterface
type shards struct {
	*gentype.ClientWithListAndApply[*corev1alpha1.Shard, *corev1alpha1.ShardList, *applyconfigurationcorev1alpha1.ShardApplyConfiguration]
}

// newShards returns a Shards
func newShards(c *CoreV1alpha1Client) *shards {
	return &shards{
		gentype.NewClientWithListAndApply[*corev1alpha1.Shard, *corev1alpha1.ShardList, *applyconfigurationcorev1alpha1.ShardApplyConfiguration](
			"shards",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *corev1alpha1.Shard { return &corev1alpha1.Shard{} },
			func() *corev1alpha1.ShardList { return &corev1alpha1.ShardList{} },
		),
	}
}
